% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_class_01_operations.R
\docType{class}
\name{operations,-class}
\alias{operations,-class}
\alias{operations}
\alias{operations-class}
\title{S4 Class operations}
\description{
This class is used for objects that contain all transactions of the business plan.
}
\section{Slots}{

\describe{
\item{\code{period}}{A character vector defining beginning and end of the time period covered by the business plan.
Values can either be a vector of two in \code{YYYY.MM} format,
      or a numeric vector of full fiscal years which will automatically be
transformed into character.}

\item{\code{revenue}}{Data frame containing \code{type}, \code{category}, \code{name},
      and all revenues,
      each month in a column named \code{YYYY.MM}. If these are not covering \code{period} exactly, missing values will be set to zero.}

\item{\code{expense}}{Data frame containing all expenses,
      data structure like the \code{revenue} slot.}

\item{\code{loan}}{Data frame,
      basically the \code{plan} slot as in \code{\link[businessPlanR:transaction_plan-class]{transaction_plan}} with
\code{plan_type="loan"}.}

\item{\code{depreciation}}{Data frame, like \code{loan},
      but with \code{plan_type="depreciation"}, respectively.}

\item{\code{misc}}{A list to keep miscellaneous data or information for documentation or re-use.}
}}

\section{Constructor function}{

Should you need to manually generate objects of this class, the constructor function 
\code{operations(...)} can be used instead of
\code{new("operations", ...)}.
}

\examples{
rev_2019_2021_merch <- revenue(
   type="Sale",
   category="Merch",
   name="T-Shirts",
   "2019.01"=100,
   "2019.08"=267,
   "2020.03"=344,
   "2020.09"=549,
   "2021.02"=770,
   "2021.07"=1022,
   "2021.12"=1263
)
rev_2019_2021_rec <- revenue(
   type="Sale",
   category="Records",
   name="Albums",
   "2019.01"=220,
   "2019.08"=234,
   "2020.03"=221,
   "2020.09"=354,
   "2021.02"=276,
   "2021.07"=285,
   "2021.12"=311
)
rev_2019_2021_inv <- revenue(
   type="Invest income",
   category="Rent",
   name="Studio",
   "2019.01"=120,
   "2019.08"=234,
   "2020.03"=321,
   "2020.09"=454,
   "2021.02"=376,
   "2021.07"=385,
   "2021.12"=211
)
exp_2019_2021_merch <- expense(
   type="Goods",
   category="Merch",
   name="T-Shirts",
   "2019.01"=65,
   "2019.07"=170,
   "2020.02"=210,
   "2020.08"=312,
   "2021.01"=450,
   "2021.06"=600,
   "2021.12"=720
)
exp_2019_2021_rec <- expense(
   type="Goods",
   category="Records",
   name="Pressing",
   "2019.01"=1860,
   "2019.02"=0,
   "2020.08"=600,
   "2020.09"=0,
   "2021.12"=0
)

op_2019_2021 <- operations(
    period=c("2019.01", "2021.12") # alternative: 2019:2021
) 
update_operations(op_2019_2021) <- rev_2019_2021_merch
update_operations(op_2019_2021) <- exp_2019_2021_merch
update_operations(op_2019_2021) <- rev_2019_2021_rec
update_operations(op_2019_2021) <- exp_2019_2021_rec
update_operations(op_2019_2021) <- rev_2019_2021_inv
}
\keyword{classes}
