% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/growth.R
\name{growth}
\alias{growth}
\title{Growth of a numeric vector}
\usage{
growth(x, round = c("round", "ceiling", "floor"), digits = 0, init = x[1])
}
\arguments{
\item{x}{A numeric vector.}

\item{round}{One of \code{"round"} (invokes \code{\link[base:round]{round}} on \code{x} before calculation),
\code{"ceiling"} (calling \code{\link[base:ceiling]{ceiling}}), or \code{"floor"} (calling
\code{\link[base:floor]{floor}} instead of \code{round}, respectively).}

\item{digits}{Integer, passed to \code{round} if \code{round="round"}.}

\item{init}{Numeric, the initial value to compare the first element of \code{x} to.}
}
\value{
A numeric vector the same length as \code{x}.
}
\description{
Calculates the differences between consecutive values in a numeric vector.
}
\examples{
growth(c(1,10,12,15,122))
}
