% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_method_get_set_as.R
\docType{methods}
\name{get_revenue}
\alias{get_revenue}
\alias{get_revenue,operations-method}
\alias{get_revenue,-methods}
\alias{get_expense}
\alias{get_expense,operations-method}
\alias{get_expense,-methods}
\alias{get_value}
\alias{get_value,transaction_plan-method}
\alias{get_value,-methods}
\alias{get_value,loan-method}
\alias{get_value,depreciation-method}
\alias{get_value,revenue-method}
\alias{get_value,expense-method}
\alias{get_loans}
\alias{get_loans,operations-method}
\alias{get_loans,-methods}
\alias{get_plan}
\alias{get_plan,transaction_plan-method}
\alias{get_plan,-methods}
\alias{get_period}
\alias{get_period,operations-method}
\alias{get_period,-methods}
\alias{get_period,transaction_plan-method}
\alias{get_period,loan-method}
\alias{get_period,depreciation-method}
\alias{get_depreciation_plan}
\alias{get_depreciation_plan,operations-method}
\alias{get_depreciation_plan,-methods}
\alias{get_plan_type}
\alias{get_plan_type,transaction_plan-method}
\alias{get_plan_type,-methods}
\alias{get_misc}
\alias{get_misc,operations-method}
\alias{get_misc,-methods}
\alias{set_misc<-}
\alias{set_misc<-,operations-method}
\alias{set_misc<-,-methods}
\alias{list_plans}
\alias{list_plans,transaction_plan-method}
\alias{list_plans,-methods}
\alias{get_sum}
\alias{get_sum,revenue-method}
\alias{get_sum,-methods}
\alias{get_sum,expense-method}
\alias{as_transaction}
\alias{as_transaction,loan-method}
\alias{as_transaction,-methods}
\alias{as_transaction,depreciation-method}
\title{Getter/setter methods for businessPlanR objects}
\usage{
get_revenue(
  obj,
  drop_nonyear_cols = FALSE,
  resolution = c("month", "quarter", "year"),
  only_type,
  not_type
)

\S4method{get_revenue}{operations}(
  obj,
  drop_nonyear_cols = FALSE,
  resolution = c("month", "quarter", "year"),
  only_type,
  not_type
)

get_expense(
  obj,
  drop_nonyear_cols = FALSE,
  resolution = c("month", "quarter", "year"),
  only_type,
  not_type
)

\S4method{get_expense}{operations}(
  obj,
  drop_nonyear_cols = FALSE,
  resolution = c("month", "quarter", "year"),
  only_type,
  not_type
)

get_value(
  obj,
  drop_nonyear_cols = FALSE,
  resolution = c("month", "quarter", "year")
)

\S4method{get_value}{transaction_plan}(
  obj,
  drop_nonyear_cols = FALSE,
  resolution = c("month", "quarter", "year")
)

\S4method{get_value}{loan}(
  obj,
  drop_nonyear_cols = FALSE,
  resolution = c("month", "quarter", "year")
)

\S4method{get_value}{depreciation}(
  obj,
  drop_nonyear_cols = FALSE,
  resolution = c("month", "quarter", "year")
)

\S4method{get_value}{revenue}(
  obj,
  drop_nonyear_cols = FALSE,
  resolution = c("month", "quarter", "year")
)

\S4method{get_value}{expense}(
  obj,
  drop_nonyear_cols = FALSE,
  resolution = c("month", "quarter", "year")
)

get_loans(obj, as_data_frame = TRUE)

\S4method{get_loans}{operations}(obj, as_data_frame = TRUE)

get_plan(obj, type, category, name, valid_types = "default")

\S4method{get_plan}{transaction_plan}(obj, type, category, name, valid_types = "default")

get_period(obj, years = FALSE)

\S4method{get_period}{operations}(obj, years = FALSE)

\S4method{get_period}{transaction_plan}(obj, years = FALSE)

\S4method{get_period}{loan}(obj, years = FALSE)

\S4method{get_period}{depreciation}(obj, years = FALSE)

get_depreciation_plan(obj, as_data_frame = TRUE)

\S4method{get_depreciation_plan}{operations}(obj, as_data_frame = TRUE)

get_plan_type(obj)

\S4method{get_plan_type}{transaction_plan}(obj)

get_misc(obj, name)

\S4method{get_misc}{operations}(obj, name)

set_misc(obj, name) <- value

\S4method{set_misc}{operations}(obj, name) <- value

list_plans(obj)

\S4method{list_plans}{transaction_plan}(obj)

get_sum(obj)

\S4method{get_sum}{revenue}(obj)

\S4method{get_sum}{expense}(obj)

as_transaction(obj, to, aspect, valid_types = "default", type)

\S4method{as_transaction}{loan}(
  obj,
  to = c("revenue", "expense"),
  aspect = c("interest", "balance_start", "principal", "total", "cumsum",
    "balance_remain"),
  valid_types = "default",
  type
)

\S4method{as_transaction}{depreciation}(
  obj,
  to = c("revenue", "expense"),
  aspect = c("investment", "depreciation", "value"),
  valid_types = "default",
  type
)
}
\arguments{
\item{obj}{An object of class
\code{\link[businessPlanR:operations-class]{operations}},
\code{\link[businessPlanR:revenue-class]{revenue}},
\code{\link[businessPlanR:expense-class]{expense}},
\code{\link[businessPlanR:transaction_plan-class]{transaction_plan}},
\code{\link[businessPlanR:loan-class]{loan}} or
\code{\link[businessPlanR:depreciation-class]{depreciation}}.}

\item{drop_nonyear_cols}{Logical, whether to drop or keep columns specifying type,
      category or name or rows.}

\item{resolution}{One of \code{"month"}, \code{"quarter"}, or \code{"year"}.}

\item{only_type}{Optional character vector, if given,
      only rows with matching type are returned.
Overrides \code{not_type} if both are provided.}

\item{not_type}{Optional character vector, if given,
      only rows with types not matching the vector entries are returned.}

\item{as_data_frame}{Logical,
      if \code{FALSE} returns an object of class \code{transaction_plan}
instead of a data frame.}

\item{type}{Character string, a valid type name for the resulting object.}

\item{category}{A character string, custom category for this transaction.}

\item{name}{Character or integer, specifying which element to get/set. If missing,
      the whole list is returned/replaced.}

\item{valid_types}{A character string, the model types defined by
\code{\link[businessPlanR:set_types]{set_types}} to be used for validation.
If \code{"default"}, pre-defined example types are used.}

\item{years}{Logical,
      if \code{TRUE} doesn't return the period vector but a vector of all years in the period.}

\item{value}{A value to assign to the object.}

\item{to}{Character string, the transaction class to coerce into.}

\item{aspect}{Character string,
      the row/column of the input objects's \code{value} data frame to use in the resulting object.
All additional data are silently dropped.}
}
\value{
Depending on the method, either a data frame or a numeric value.
}
\description{
These methods return the requested slots from objects of class
\code{\link[businessPlanR:operations-class]{operations}},
\code{\link[businessPlanR:revenue-class]{revenue}},
\code{\link[businessPlanR:expense-class]{expense}},
\code{\link[businessPlanR:transaction_plan-class]{transaction_plan}},
\code{\link[businessPlanR:loan-class]{loan}} or
\code{\link[businessPlanR:depreciation-class]{depreciation}},
or, in case of their \code{<-} counterparts, replace slots with a given \code{value}.
}
\details{
If \code{as_transaction(..., aspect="balance_start")} is being called on a loan object,
      only the initial
value (and perhaps growth instead of declining values) is used,
      e.g. as revenue for calculations.
}
