% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fin_needs.R
\name{fin_needs}
\alias{fin_needs}
\title{Estimate capital requirement from cash flow}
\usage{
fin_needs(
  cashflow_df,
  resolution = c("year", "quarter", "month"),
  row_names = c("Financial needs", "Cumulative")
)
}
\arguments{
\item{cashflow_df}{Data frame as returned by \code{\link[businessPlanR:condense-methods]{condense}} with \code{cashflow=TRUE}.}

\item{resolution}{One of \code{"month"}, \code{"quarter"},
      or \code{"year"}. Must be identical
to the value used with the call to \code{condense}!}

\item{row_names}{Character vector of two, names for the rows of the resulting data frame.
The first represents financial need per time period (column),
      the second is cumulated over all columns.}
}
\value{
A data frame with two rows and columns depending on \code{resolution} and period covered by \code{cashflow_df}.
}
\description{
To avoid cash flow issues, this function takes a data frame as returned by
\code{\link[businessPlanR:condense]{condense}} with \code{cashflow=TRUE} to calculate
the amount of financial needs per time resolution.
}
\details{
Only negative values are returned, so the row sum can be used as an estimate
of the overall financial demand for the given period of time.
}
