% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmst_point_estimate.R
\name{rmst_point_estimate}
\alias{rmst_point_estimate}
\title{Calculate the point estimate of the marginal restricted mean survival time (RMST) when adjusting covariates in clinical trials}
\usage{
rmst_point_estimate(fit, dt, tau)
}
\arguments{
\item{fit}{A \link[survival]{coxph} object with strata(trt) in the model. See example.}

\item{dt}{A data frame used for the fit - coxph model including survival time, OS status, trt, and covariates.}

\item{tau}{Numeric. A value for the restricted time or the pre-specified cutoff time point.}
}
\value{
A list containing the RMST, cumulative survival function, and cumulative hazard function.
\describe{
\item{output}{Marginal RMST}
\item{surv0}{Cumulative survival function for the placebo group}
\item{cumhaz0}{Cumulative hazard function for the placebo group}
\item{surv1}{Cumulative survival function for the treatment group}
\item{cumhaz1}{Cumulative hazard function for the treatment group}
}
}
\description{
Estimate the marginal RMST (point estimate) using the Karrison et al.(2018).
}
\details{
Restricted mean survival time is a measure of average survival time up to a specified time point. We adopted the methods from Karrison et al.(2018) for
estimating the marginal RMST when adjusting covariates.
}
\examples{
library(survival)
data("oak")

tau <- 26
time <- oak$OS
status <- oak$os.status
trt <- oak$trt
covariates <- oak[, c("btmb", "pdl1")]
dt <- as.data.frame(cbind(time, status, trt, covariates))
fit <- coxph(Surv(time, status) ~ btmb + pdl1 + strata(trt), data = dt)
delta <- rmst_point_estimate(fit, dt = dt, tau)
delta$output
}
\references{
\itemize{
\item Karrison T, Kocherginsky M. Restricted mean survival time: Does covariate adjustment improve precision in randomized clinical trials? Clinical Trials. 2018;15(2):178-188. doi:10.1177/1740774518759281
\item Zucker, D. M. (1998). Restricted Mean Life with Covariates: Modification and Extension of a Useful Survival Analysis Method. Journal of the American Statistical Association, 93(442), 702–709. https://doi.org/10.1080/01621459.1998.10473722
\item Wei, J., Xu, J., Bornkamp, B., Lin, R., Tian, H., Xi, D., … Roychoudhury, S. (2024). Conditional and Unconditional Treatment Effects in Randomized Clinical Trials: Estimands, Estimation, and Interpretation. Statistics in Biopharmaceutical Research, 16(3), 371–381. https://doi.org/10.1080/19466315.2023.2292774
\item Chen, P. and Tsiatis, A. (2001), “Causal Inference on the Difference of the Restricted Mean Lifetime Between Two Groups,” Biometrics; 57: 1030–1038. DOI: 10.1111/j.0006-341x.2001.01030.x.
}
}
