% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise.R
\name{add_nobs_to_pairwise}
\alias{add_nobs_to_pairwise}
\title{Adds number of observations column to pairwise tibble}
\usage{
add_nobs_to_pairwise(scores, d, by = NULL)
}
\arguments{
\item{scores}{An object of class \code{pairwise}, calculated from dataset d.}

\item{d}{a dataframe}

\item{by}{a character string for the name of the conditioning variable from d used to construct scores. Set to \code{NULL} by default.}
}
\value{
A pairwise tibble with a column \code{n}
}
\description{
Adds number of observations column to pairwise tibble
}
\examples{
irisc <- pairwise_scores(iris[40:150,], by= "Species")
irisc <- add_nobs_to_pairwise(irisc, iris[40:150,], by= "Species")
irisc
plot_pairwise(irisc) # setosa gets a small slice in proportion to n
}
