% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QCplotFuns.R
\name{scatter_plot}
\alias{scatter_plot}
\title{Create a scatter plot of expression between two samples of an experiment}
\usage{
scatter_plot(
  sub.expression.matrix,
  anno,
  genes.to.highlight = c(),
  log.transformation = TRUE
)
}
\arguments{
\item{sub.expression.matrix}{subset of the expression matrix containing only the two
selected samples}

\item{anno}{annotation data frame containing a match between the row names
of the expression.matrix (usually ENSEMBL IDs) and the gene names that
should be rendered within the app and in output files; this object is
created by \code{\link{generateShinyApp}} using the org.db specified}

\item{genes.to.highlight}{vector of gene names to highlight.
These should match entries in the anno NAME column.}

\item{log.transformation}{whether expression should be shown on log (default) or
linear scale}
}
\value{
The scatter plot as a ggplot object.
}
\description{
This function creates a scatter plot between two samples.
}
\examples{
expression.matrix.preproc <- as.matrix(read.csv(
  system.file("extdata", "expression_matrix_preprocessed.csv", package = "bulkAnalyseR"), 
  row.names = 1
))[,1:2]

print(scatter_plot(expression.matrix.preproc, c()))

}
