% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modalityPanel.R
\name{modalityPanel}
\alias{modalityPanel}
\alias{modalityPanelUI}
\alias{modalityPanelServer}
\title{Generate an app panel for a modality}
\usage{
modalityPanelUI(id, metadata, organism, panels.default)

modalityPanelServer(
  id,
  expression.matrix,
  metadata,
  anno,
  organism,
  panels.default
)
}
\arguments{
\item{id}{the input slot that will be used to access the value}

\item{metadata}{a data frame containing metadata for the samples contained
in the expression.matrix; must contain at minimum two columns:
the first column must contain the column names of the expression.matrix,
while the last column is assumed to contain the experimental conditions
that will be tested for differential expression; a list  (of the same
length as modality) can be provided if #' \code{length(modality) > 1}}

\item{organism}{organism name to be passed on to \code{gprofiler2::gost};
organism names are constructed by concatenating the first letter of the
name and the family name; default is NA - enrichment is not included
to ensure compatibility with datasets that have non-standard gene names;
a vector (of the same length as modality) can be provided if
\code{length(modality) > 1}}

\item{panels.default}{argument to control which of the default panels
will be included in the app; default is all, but the enrichment panel
will not appear unless organism is also supplied; note that the 'DE' panel
is required for 'DEplot', 'DEsummary', 'Enrichment', and 'GRNenrichment'; a list  (of the same
length as modality) can be provided if \code{length(modality) > 1}}

\item{expression.matrix}{the expression matrix; rows correspond to genes and
columns correspond to samples; usually preprocessed by
\code{\link{preprocessExpressionMatrix}}; a list  (of the same length as
modality) can be provided if #' \code{length(modality) > 1}}

\item{anno}{annotation data frame containing a match between the row names
of the expression.matrix (usually ENSEMBL IDs) and the gene names that
should be rendered within the app and in output files; this object is
created by \code{\link{generateShinyApp}} using the org.db specified}
}
\value{
The UI and Server components of the shiny module, that can be used
within the UI and Server definitions of a shiny app.
}
\description{
These are the UI and server components of a modality
panel of the shiny app. Different modalities can be included by
specifying their inputs in \code{\link{generateShinyApp}}.
}
