% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildmer.r
\name{buildmer}
\alias{buildmer}
\title{Use \code{buildmer} to fit mixed-effects models using \code{lmer}/\code{glmer} from \code{lme4}}
\usage{
buildmer(
  formula,
  data = NULL,
  family = gaussian(),
  buildmerControl = buildmerControl()
)
}
\arguments{
\item{formula}{See the general documentation under \code{\link{buildmer-package}}}

\item{data}{See the general documentation under \code{\link{buildmer-package}}}

\item{family}{See the general documentation under \code{\link{buildmer-package}}}

\item{buildmerControl}{Control arguments for buildmer --- see the general documentation under \code{\link{buildmerControl}}}
}
\description{
Use \code{buildmer} to fit mixed-effects models using \code{lmer}/\code{glmer} from \code{lme4}
}
\examples{
library(buildmer)
model <- buildmer(Reaction ~ Days + (Days|Subject),lme4::sleepstudy)

# Tests from github issue #2, that also show the use of the 'direction' and 'crit' parameters:
bm.test <- buildmer(cbind(incidence,size - incidence) ~ period + (1 | herd),
	family=binomial,data=lme4::cbpp)
bm.test <- buildmer(cbind(incidence,size - incidence) ~ period + (1 | herd),
	family=binomial,data=lme4::cbpp,buildmerControl=buildmerControl(direction='forward'))
bm.test <- buildmer(cbind(incidence,size - incidence) ~ period + (1 | herd),
	family=binomial,data=lme4::cbpp,buildmerControl=buildmerControl(crit='AIC'))
bm.test <- buildmer(cbind(incidence,size - incidence) ~ period + (1 | herd),
	family=binomial,data=lme4::cbpp,
	buildmerControl=buildmerControl(direction='forward',crit='AIC'))

# Example showing use of the 'include' parameter to force a particular term into the model
m1 <- buildmer(Reaction ~ Days,data=lme4::sleepstudy,buildmerControl=list(include=~(1|Subject)))
# the below are equivalent
m2 <- buildmer(Reaction ~ Days,data=lme4::sleepstudy,buildmerControl=list(include='(1|Subject)'))
m3 <- buildmer(Reaction ~ Days + (1|Subject),data=lme4::sleepstudy,buildmerControl=list(
	include=~(1|Subject)))
m4 <- buildmer(Reaction ~ Days + (1|Subject),data=lme4::sleepstudy,buildmerControl=list(
	include='(1|Subject)'))
}
