% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/btw.R
\name{btw}
\alias{btw}
\title{Plain-text descriptions of R objects}
\usage{
btw(..., clipboard = TRUE)
}
\arguments{
\item{...}{Objects to describe from your R environment. You can pass objects
themselves, like data frames or functions, or the function also accepts
output from \verb{btw_tool_*()} functions like
\code{\link[=btw_tool_docs_package_help_topics]{btw_tool_docs_package_help_topics()}}, \code{\link[=btw_tool_docs_help_page]{btw_tool_docs_help_page()}}, etc. If
omitted, this function will just describe the elements in your global R
environment.}

\item{clipboard}{Whether to write the results to the clipboard.
A single logical value; will default to \code{TRUE} when run interactively.}
}
\value{
Returns an \link[ellmer:Content]{ellmer::ContentText} object with the collected prompt. If
\code{clipboard = TRUE}, the prompt text is copied to the clipboard when the
returned object is printed for the first time (e.g. calling \code{btw()} without
assignment).
}
\description{
This function allows you to quickly describe your computational environment
to a model by concatenating plain-text descriptions of "R stuff", from
data frames to packages to function documentation.

There are two key ways to use \code{btw()}:
\enumerate{
\item Use it interactively at the console to gather information about your
environment into prompt text that you can paste into the chat interface of
an LLM, like ChatGPT or Claude. By default, \code{btw()} copies the prompt to
the clipboard for you.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{btw(vignette("colwise", "dplyr"), dplyr::across, dplyr::starwars)
#> btw copied to the clipboard!
}\if{html}{\out{</div>}}
\item Pair \code{btw()} with \link[ellmer:Chat]{ellmer::Chat} during a chat session to create a prompt
that includes additional context drawn from your environment and help
pages.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(ellmer)

chat <- chat_anthropic() # requires an Anthropic API key
chat <- chat_ollama(model = "llama3.1:8b") # requires ollama and a local model

chat$chat(btw(
  vignette("colwise", "dplyr"),
  dplyr::across,
  dplyr::starwars,
  "Create a few interesting examples that use `dplyr::across()`",
  "with the `starwars` data set."
))
}\if{html}{\out{</div>}}
}
\subsection{Additional examples}{
\enumerate{
\item Use \code{btw()} without arguments to describe all objects in your workspace:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{btw()
#> btw copied to the clipboard!
}\if{html}{\out{</div>}}
\item Describe a function (it's documentation) and a data frame:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{btw(dplyr::mutate, mtcars)
#> btw copied to the clipboard!
}\if{html}{\out{</div>}}
\item Use \code{btw()} to give additional context to an \link[ellmer:Chat]{ellmer::Chat} session:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(ellmer)

chat <- chat_ollama(model = "llama3.1:8b")
chat$chat(
  btw(mtcars, "Are there cars with 8 cylinders in this dataset?")
)
}\if{html}{\out{</div>}}
}
}
}
\examples{
# See documentation for detailed examples
btw(mtcars)

}
