% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_synth_draws.R
\name{.get_synth_draws3d}
\alias{.get_synth_draws3d}
\title{Get Synthetic Draws in Tidy Format for Multiple Treated Units (3D Array)}
\usage{
.get_synth_draws3d(fit, data, id, treated_ids, time, outcome, intervention)
}
\arguments{
\item{fit}{A Stan fit object containing the model results.}

\item{data}{A data frame with the input data, including outcome, time, and unit identifier.}

\item{id}{The name of the variable in \code{data} that identifies units (as a string).}

\item{treated_ids}{A vector of identifiers for the treated units.}

\item{time}{The name of the time period variable (as a string).}

\item{outcome}{The name of the outcome variable (as a string).}

\item{intervention}{The name of the variable in \code{data} that indicates the intervention time (as a string).}
}
\value{
A data frame containing:
\itemize{
\item \code{draw}: The index of the synthetic draw.
\item \code{id}: The identifier of the treated unit.
\item \code{time}: The time period.
\item \code{y_hat}: The synthetic outcome for the given draw, unit, and time period.
}
}
\description{
This internal helper function extracts synthetic draws from a Stan fit object
where the draws are stored in a 3D array. It handles multiple treated units and
combines the draws with observed outcome data, returning a tidy data frame
suitable for analysis or plotting.
}
