% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute.R
\name{compute_variance_decompositions.PosteriorBSVARSIGN}
\alias{compute_variance_decompositions.PosteriorBSVARSIGN}
\title{Computes posterior draws of the forecast error variance decomposition}
\usage{
\method{compute_variance_decompositions}{PosteriorBSVARSIGN}(posterior, horizon)
}
\arguments{
\item{posterior}{posterior estimation outcome - an object of class 
\code{PosteriorBSVARSIGN} obtained by running the \code{estimate} function.}

\item{horizon}{a positive integer number denoting the forecast horizon for 
the impulse responses computations.}
}
\value{
An object of class \code{PosteriorFEVD}, that is, an \code{NxNx(horizon+1)xS} 
array with attribute \code{PosteriorFEVD} containing \code{S} draws of the 
forecast error variance decomposition.
}
\description{
Each of the draws from the posterior estimation of the model
is transformed into a draw from the posterior distribution of the forecast 
error variance decomposition.
}
\examples{
# upload data
data(optimism)

# specify the model and set seed
set.seed(123)

# + no effect on productivity (zero restriction)
# + positive effect on stock prices (positive sign restriction) 
sign_irf       = matrix(c(0, 1, rep(NA, 23)), 5, 5)
specification  = specify_bsvarSIGN$new(optimism, sign_irf = sign_irf)

# estimate the model
posterior      = estimate(specification, 10)

# compute forecast error variance decomposition 2 years ahead
fevd           = compute_variance_decompositions(posterior, horizon = 8)

# workflow with the pipe |>
############################################################
set.seed(123)
optimism |>
  specify_bsvarSIGN$new(sign_irf = sign_irf) |> 
  estimate(S = 10) |> 
  compute_variance_decompositions(horizon = 8) -> fevd
  
}
\references{
Kilian, L., & Lütkepohl, H. (2017). Structural VAR Tools, Chapter 4, In: Structural vector autoregressive analysis. Cambridge University Press.
}
\seealso{
\code{\link{compute_impulse_responses.PosteriorBSVARSIGN}}, \code{\link{estimate.BSVARSIGN}}, \code{\link{summary}}, \code{\link{plot}}
}
\author{
Xiaolei Wang \email{adamwang15@gmail.com} and Tomasz Woźniak \email{wozniak.tom@pm.me}
}
