% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/streaming_link_object.R
\name{fromentities}
\alias{fromentities}
\title{Create a streaming link object from known record entity id's}
\usage{
fromentities(...)
}
\arguments{
\item{...}{Vectors containing entity IDs of each record in each file.
Each parameter represents the records in a file. The values are an
entity ID for the records in that file. Two records having the same
entity ID are coreferent.}
}
\value{
A streaming link object with S3 class 'streaminglinks', defining the
links between records implied by the supplied entity IDs
}
\description{
Create a streaming link object from known record entity id's
}
\examples{
data(geco_30over_3err)

file1 <- geco_30over_3err[[1]]
file2 <- geco_30over_3err[[2]]
file3 <- geco_30over_3err[[3]]
file4 <- geco_30over_3err[[4]]

fromentities(file1$entity, file2$entity, file3$entity, file4$entity)

}
