% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bsnsing.R
\name{ROC_func}
\alias{ROC_func}
\title{Plot the ROC curve and calculate the AUC}
\usage{
ROC_func(
  df,
  label_colnum,
  score_colnum,
  pos.label = "1",
  plot.ROC = FALSE,
  add_on = FALSE,
  color = "black",
  lty = 1
)
}
\arguments{
\item{df}{a data frame which must contain at least these two columns: the prediction scores (numeric values, not necessarily be between 0 and 1) and the true class labels.}

\item{label_colnum}{the column index of the scores column in df.}

\item{score_colnum}{the column index of the true class labels column in df.}

\item{pos.label}{a character string matching the positive class label used in the class labels column.}

\item{plot.ROC}{a logical value indicating whether the ROC curve should be plotted.}

\item{add_on}{a logical value indicating whether the ROC curve should be added to an existing plot.}

\item{color}{a character string specifying the color of the ROC curve in the plot.}

\item{lty}{line type used in the plot, 1 solid, 2 dashed, etc.}
}
\value{
a numeric value representing the area under the ROC curve (AUC).
}
\description{
This is a general utility function, not part of the bsnsing functionality.
}
\examples{
n <- nrow(BreastCancer)
trainset <- sample(1:n, 0.7*n)  # randomly sample 70\% for training
testset <- setdiff(1:n, trainset)  # the remaining is for testing
# Build a tree to predict Class, using all default options
bs <- bsnsing(Class~., data = BreastCancer[trainset,])
summary(bs)  # display the tree structure
pred <- predict(bs, BreastCancer[testset,], type='class')
actual <- BreastCancer[testset, 'Class']
table(pred, actual)  # display the confusion matrix
# Plot the ROC curve and display the AUC
ROC_func(data.frame(predict(bs, BreastCancer[testset,]), 
                    BreastCancer[testset,'Class']), 
         2, 1, pos.label = 'malignant', plot.ROC=TRUE)
}
