% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_model_criterion.R
\name{add_model_criterion.bgmfit}
\alias{add_model_criterion.bgmfit}
\alias{add_model_criterion}
\title{Add Model Fit Criteria to Model}
\usage{
\method{add_model_criterion}{bgmfit}(
  model,
  criterion = c("loo", "waic"),
  ndraws = NULL,
  draw_ids = NULL,
  compare = TRUE,
  pointwise = FALSE,
  model_names = NULL,
  summary = TRUE,
  robust = FALSE,
  probs = c(0.025, 0.975),
  newdata = NULL,
  resp = NULL,
  cores = 1,
  deriv_model = NULL,
  verbose = FALSE,
  expose_function = FALSE,
  usesavedfuns = NULL,
  clearenvfuns = NULL,
  envir = NULL,
  ...
)

add_model_criterion(model, ...)
}
\arguments{
\item{model}{An object of class \code{bgmfit} representing the model to which
the fit criteria will be added.}

\item{criterion}{Names of model fit criteria
to compute. Currently supported are \code{"loo"},
\code{"waic"}, \code{"kfold"}, \code{"loo_subsample"},
\code{"bayes_R2"} (Bayesian R-squared),
\code{"loo_R2"} (LOO-adjusted R-squared), and
\code{"marglik"} (log marginal likelihood).}

\item{ndraws}{A positive integer indicating the number of posterior draws to
use in estimation. If \code{NULL} (default), all draws are used.}

\item{draw_ids}{An integer specifying the specific posterior draw(s) to use
in estimation (default \code{NULL}).}

\item{compare}{A flag indicating if the information criteria
of the models should be compared to each other
via \code{\link[brms]{loo_compare}}.}

\item{pointwise}{A flag indicating whether to compute the full
log-likelihood matrix at once or separately for each observation.
The latter approach is usually considerably slower but
requires much less working memory. Accordingly, if one runs
into memory issues, \code{pointwise = TRUE} is the way to go.}

\item{model_names}{If \code{NULL} (the default) will use model names
derived from deparsing the call. Otherwise will use the passed
values as model names.}

\item{summary}{A logical value indicating whether only the estimate should be
computed (\code{TRUE}), or whether the estimate along with SE and CI should
be returned (\code{FALSE}, default). Setting \code{summary} to \code{FALSE}
will increase computation time. Note that \code{summary = FALSE} is
required to obtain correct estimates when \code{re_formula = NULL}.}

\item{robust}{A logical value to specify the summary options. If \code{FALSE}
(default), the mean is used as the measure of central tendency and the
standard deviation as the measure of variability. If \code{TRUE}, the
median and median absolute deviation (MAD) are applied instead. Ignored if
\code{summary} is \code{FALSE}.}

\item{probs}{The percentiles to be computed by the \code{quantile}
function. Only used if \code{summary} is \code{TRUE}.}

\item{newdata}{An optional data frame for estimation. If \code{NULL}
(default), \code{newdata} is retrieved from the \code{model}.}

\item{resp}{A character string (default \code{NULL}) to specify the response
variable when processing posterior draws for \code{univariate_by} and
\code{multivariate} models. See \code{\link[=bsitar]{bsitar()}} for details on
\code{univariate_by} and \code{multivariate} models.}

\item{cores}{The number of cores to be used for parallel computations if
\code{future = TRUE}. On non-Windows systems, this argument can be set
globally via the \code{mc.cores} option. By default, \code{NULL}, the
number of cores is automatically determined using
\code{\link[future:re-exports]{future::availableCores()}}, and it will use the maximum number of cores
available minus one (i.e., \code{future::availableCores() - 1}).}

\item{deriv_model}{A logical value specifying whether to estimate the
velocity curve from the derivative function or by differentiating the
distance curve. Set \code{deriv_model = TRUE} for functions that require
the velocity curve, such as \code{growthparameters()} and
\code{plot_curves()}. Set it to \code{NULL} for functions that use the
distance curve (i.e., fitted values), such as \code{loo_validation()} and
\code{plot_ppc()}.}

\item{verbose}{A logical argument (default \code{FALSE}) to specify whether
to print information collected during the setup of the object(s).}

\item{expose_function}{A logical argument (default \code{FALSE}) to indicate
whether Stan functions should be exposed. If \code{TRUE}, any Stan
functions exposed during the model fit using \code{expose_function = TRUE}
in the \code{\link[=bsitar]{bsitar()}} function are saved and can be used in post-processing. By
default, \code{expose_function = FALSE} in post-processing functions,
except in \code{\link[=optimize_model]{optimize_model()}} where it is set to \code{NULL}. If
\code{NULL}, the setting is inherited from the original model fit. It must
be set to \code{TRUE} when adding \code{fit criteria} or \code{bayes_R2}
during model optimization.}

\item{usesavedfuns}{A logical value (default \code{NULL}) indicating whether
to use already exposed and saved Stan functions. This is typically set
automatically based on the \code{expose_functions} argument from the
\code{\link[=bsitar]{bsitar()}} call. Manual specification of \code{usesavedfuns} is rarely
needed and is intended for internal testing, as improper use can lead to
unreliable estimates.}

\item{clearenvfuns}{A logical value indicating whether to clear the exposed
Stan functions from the environment (\code{TRUE}) or not (\code{FALSE}). If
\code{NULL}, \code{clearenvfuns} is set based on the value of
\code{usesavedfuns}: \code{TRUE} if \code{usesavedfuns = TRUE}, or
\code{FALSE} if \code{usesavedfuns = FALSE}.}

\item{envir}{The environment used for function evaluation. The default is
\code{NULL}, which sets the environment to \code{parent.frame()}. Since
most post-processing functions rely on \pkg{brms}, it is recommended to set
\code{envir = globalenv()} or \code{envir = .GlobalEnv}, especially for
derivatives like velocity curves.}

\item{...}{Additional arguments passed to the \code{brms::fitted.brmsfit()}
and \code{brms::predict()} functions.}
}
\value{
An object of class \code{bgmfit} with the specified fit criteria added.
}
\description{
The \strong{add_model_criterion()} function is a wrapper around
\code{\link[brms:add_criterion]{brms::add_criterion()}} that allows adding fit criteria to a model. Note
that arguments such as \code{compare} and \code{pointwise} are relevant
only for \link[brms:add_ic]{brms::add_loo}, while \code{summary}, \code{robust}, and
\code{probs} are ignored except for the \code{\link[brms:bayes_R2.brmsfit]{brms::bayes_R2()}}.
}
\examples{

\donttest{
# Fit Bayesian SITAR model 

# To avoid model estimation which can take time, the Bayesian SITAR model fit
# to the 'berkeley_exdata' has been saved as an example fit ('berkeley_exfit').
# See 'bsitar' function for details on 'berkeley_exdata' and 'berkeley_exfit'.

model <- berkeley_exfit

# Add model fit criteria (e.g., WAIC)
model <- add_model_criterion(model, criterion = c("waic"))
}

}
\seealso{
\link[brms:add_ic]{brms::add_loo}, \code{\link[brms:add_ic]{brms::add_ic()}}, \code{\link[brms:add_ic]{brms::add_waic()}},
\code{\link[brms:bayes_R2.brmsfit]{brms::bayes_R2()}}
}
\author{
Satpal Sandhu  \email{satpal.sandhu@bristol.ac.uk}
}
