% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bruceR-stats_1_basic.R
\name{add}
\alias{add}
\alias{added}
\title{Create, modify, and delete variables.}
\usage{
add(data, expr, when, by, drop = FALSE)

added(data, expr, when, by, drop = FALSE)
}
\arguments{
\item{data}{A \code{\link[data.table:data.table]{data.table}} (preferred).}

\item{expr}{Passing to \code{\link[data.table:data.table]{data.table}}: \code{DT[ , let(expr), ]}

R expression(s) to compute variables. Execute each line of expression \emph{one by one}, such that newly created variables are available immediately. This is an advantage of \code{\link[dplyr:mutate]{dplyr::mutate()}} and has been implemented here for \code{\link[data.table:data.table]{data.table}}.}

\item{when}{[Optional] Passing to \code{\link[data.table:data.table]{data.table}}: \code{DT[when, , ]}

Compute \emph{for} which rows or rows meeting what condition(s)?}

\item{by}{[Optional] Passing to \code{\link[data.table:data.table]{data.table}}: \code{DT[ , , by]}

Compute \emph{by} what group(s)?}

\item{drop}{Drop existing variables and return only new variables? Defaults to \code{FALSE}, which returns all variables.}
}
\value{
\itemize{
\item \code{add()} returns a new \code{\link[data.table:data.table]{data.table}}, with the raw data unchanged.
\item \code{added()} returns nothing and has already changed the raw data.
}
}
\description{
Enhanced functions to create, modify, and/or delete variables. The functions \strong{integrate} the advantages of \code{\link[base:with]{base::within()}}, \code{\link[dplyr:mutate]{dplyr::mutate()}}, \code{\link[dplyr:transmute]{dplyr::transmute()}}, and \code{\link[data.table:assign]{data.table::let()}}.
}
\examples{
## ====== Usage 1: add() ====== ##

d = as.data.table(within.1)
d$XYZ = 1:8
d

# add() does not change the raw data:
add(d, {B = 1; C = 2})
d

# new data should be assigned to an object:
d = d \%>\% add({
  ID = str_extract(ID, "\\\\d")  # modify a variable
  XYZ = NULL                   # delete a variable
  A = .mean("A", 1:4)          # create a new variable
  B = A * 4    # new variable is immediately available
  C = 1        # never need ,/; at the end of any line
})
d


## ====== Usage 2: added() ====== ##

d = as.data.table(within.1)
d$XYZ = 1:8
d

# added() has already changed the raw data:
added(d, {B = 1; C = 2})
d

# raw data has already become the new data:
added(d, {
  ID = str_extract(ID, "\\\\d")
  XYZ = NULL
  A = .mean("A", 1:4)
  B = A * 4
  C = 1
})
d


## ====== Using `when` and `by` ====== ##

d = as.data.table(between.2)
d

added(d, {SCORE2 = SCORE - mean(SCORE)},
      A == 1 & B \%in\% 1:2,  # `when`: for what conditions
      by=B)                 # `by`: by what groups
d
na.omit(d)


## ====== Return Only New Variables ====== ##

newvars = add(within.1, {
  ID = str_extract(ID, "\\\\d")
  A = .mean("A", 1:4)
}, drop=TRUE)
newvars


## ====== Better Than `base::within()` ====== ##

d = as.data.table(within.1)

# wrong order: C B A
within(d, {
  A = 4
  B = A + 1
  C = 6
})

# correct order: A B C
add(d, {
  A = 4
  B = A + 1
  C = 6
})

}
