% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volume-fs.R
\name{db_volume_upload_dir}
\alias{db_volume_upload_dir}
\title{Upload Directory to Volume in Parallel}
\usage{
db_volume_upload_dir(
  local_dir,
  volume_dir,
  overwrite = TRUE,
  preserve_structure = TRUE,
  host = db_host(),
  token = db_token()
)
}
\arguments{
\item{local_dir}{Path to local directory containing files to upload}

\item{volume_dir}{Volume directory path (must start with /Volumes/)}

\item{overwrite}{Flag to overwrite existing files (default: TRUE)}

\item{preserve_structure}{If TRUE, preserve subdirectory structure (default: TRUE)}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}
}
\value{
TRUE if all uploads successful
}
\description{
Upload all files from a local directory to a volume directory using parallel requests.
}
\seealso{
Other Volumes FileSystem API: 
\code{\link{db_volume_delete}()},
\code{\link{db_volume_dir_create}()},
\code{\link{db_volume_dir_delete}()},
\code{\link{db_volume_dir_exists}()},
\code{\link{db_volume_file_exists}()},
\code{\link{db_volume_list}()},
\code{\link{db_volume_read}()},
\code{\link{db_volume_write}()}
}
\concept{Volumes FileSystem API}
