% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbfs.R
\name{db_dbfs_create}
\alias{db_dbfs_create}
\title{DBFS Create}
\usage{
db_dbfs_create(
  path,
  overwrite = FALSE,
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{path}{The path of the new file. The path should be the absolute DBFS
path (for example \verb{/mnt/my-file.txt}).}

\item{overwrite}{Boolean, specifies whether to overwrite existing file or
files.}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\value{
Handle which should subsequently be passed into \code{\link[=db_dbfs_add_block]{db_dbfs_add_block()}}
and \code{\link[=db_dbfs_close]{db_dbfs_close()}} when writing to a file through a stream.
}
\description{
Open a stream to write to a file and returns a handle to this stream.
}
\details{
There is a 10 minute idle timeout on this handle. If a file or directory
already exists on the given path and overwrite is set to \code{FALSE}, this call
throws an exception with \code{RESOURCE_ALREADY_EXISTS.}
}
\section{Typical File Upload Flow}{

\itemize{
\item Call create and get a handle via \code{\link[=db_dbfs_create]{db_dbfs_create()}}
\item Make one or more \code{\link[=db_dbfs_add_block]{db_dbfs_add_block()}} calls with the handle you have
\item Call \code{\link[=db_dbfs_close]{db_dbfs_close()}} with the handle you have
}
}

\seealso{
Other DBFS API: 
\code{\link{db_dbfs_add_block}()},
\code{\link{db_dbfs_close}()},
\code{\link{db_dbfs_delete}()},
\code{\link{db_dbfs_get_status}()},
\code{\link{db_dbfs_list}()},
\code{\link{db_dbfs_mkdirs}()},
\code{\link{db_dbfs_move}()},
\code{\link{db_dbfs_put}()},
\code{\link{db_dbfs_read}()}
}
\concept{DBFS API}
