% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_brand.R
\name{scale_brand}
\alias{scale_brand}
\alias{scale_color_brand_d}
\alias{scale_color_brand_c}
\alias{scale_color_brand_b}
\alias{scale_colour_brand_d}
\alias{scale_colour_brand_c}
\alias{scale_colour_brand_b}
\alias{scale_fill_brand_d}
\alias{scale_fill_brand_c}
\alias{scale_fill_brand_b}
\title{Brand color scales for \code{ggplot2}}
\usage{
scale_brand(
  aesthetics = "color",
  scale_type = "c",
  color_type = "seq",
  alpha = NULL,
  direction = 1,
  na.value = NA,
  reverse = FALSE,
  ...
)

scale_color_brand_d(
  aesthetics = "color",
  scale_type = "d",
  color_type = "qual",
  alpha = NULL,
  direction = 1,
  na.value = NA,
  reverse = FALSE,
  ...
)

scale_color_brand_c(
  aesthetics = "color",
  scale_type = "c",
  color_type = "seq",
  alpha = NULL,
  direction = 1,
  na.value = NA,
  reverse = FALSE,
  ...
)

scale_color_brand_b(
  aesthetics = "color",
  scale_type = "b",
  color_type = "seq",
  alpha = NULL,
  direction = 1,
  na.value = NA,
  reverse = FALSE,
  ...
)

scale_colour_brand_d(
  aesthetics = "color",
  scale_type = "d",
  color_type = "qual",
  alpha = NULL,
  direction = 1,
  na.value = NA,
  reverse = FALSE,
  ...
)

scale_colour_brand_c(
  aesthetics = "color",
  scale_type = "c",
  color_type = "seq",
  alpha = NULL,
  direction = 1,
  na.value = NA,
  reverse = FALSE,
  ...
)

scale_colour_brand_b(
  aesthetics = "color",
  scale_type = "b",
  color_type = "seq",
  alpha = NULL,
  direction = 1,
  na.value = NA,
  reverse = FALSE,
  ...
)

scale_fill_brand_d(
  aesthetics = "fill",
  scale_type = "d",
  color_type = "qual",
  alpha = NULL,
  direction = 1,
  na.value = NA,
  reverse = FALSE,
  ...
)

scale_fill_brand_c(
  aesthetics = "fill",
  scale_type = "c",
  color_type = "seq",
  alpha = NULL,
  direction = 1,
  na.value = NA,
  reverse = FALSE,
  ...
)

scale_fill_brand_b(
  aesthetics = "fill",
  scale_type = "b",
  color_type = "seq",
  alpha = NULL,
  direction = 1,
  na.value = NA,
  reverse = FALSE,
  ...
)
}
\arguments{
\item{aesthetics}{(Optional) A \code{\link[base:character]{character}} string
indicating the name of the aesthetic of the scale (e.g., \code{"color"},
\code{"fill"}) (Default: \code{"color"}).}

\item{scale_type}{(Optional) A \code{\link[base:character]{character}} string
indicating the type of scale: \code{"d"}/\code{"discrete"}, \code{"c"}/\code{"continuous"},
or \code{"b"}/\code{"binned"} (Default: \code{"c"}).}

\item{color_type}{(Optional) A \code{\link[base:character]{character}} string
indicating the type of color scale: \code{"seq"}/\code{"sequential"},
\code{"div"}/\code{"diverging"}, or \code{"qual"}/\code{"qualitative"} (Default: \code{"seq"}).}

\item{alpha}{(Optional) A number between \code{0} and \code{1}, indicating the
transparency of the colors (Default: \code{NULL}).}

\item{direction}{(Optional) A number (\code{1} or \code{-1}) indicating the direction
of the colors. If \code{1}, the order remains the same. If \code{-1}, the order is
reversed. (Default: \code{1}).}

\item{na.value}{(Optional) A \code{\link[base:character]{character}} string
indicating the color to use for missing values. It must contain a
\href{https://en.wikipedia.org/wiki/Web_colors}{hexadecimal} color code or
one of the values output by
\code{\link[grDevices:colors]{colors()}} (Default: \code{NA}).}

\item{reverse}{(Optional) A \code{\link[base:logical]{logical}} flag indicating
whether the legend or color bar should be reversed (Default: \code{FALSE}).}

\item{...}{Additional arguments passed to the \code{ggplot2} scale function:
\code{\link[ggplot2:discrete_scale]{discrete_scale()}},
\code{\link[ggplot2:continuous_scale]{continuous_scale()}}, or
\code{\link[ggplot2:binned_scale]{binned_scale()}}.}
}
\value{
A \code{\link[ggplot2:continuous_scale]{ggplot2}} scale object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}

\verb{scale_*_brand_*()} functions provide color scales for
\href{https://ggplot2.tidyverse.org/}{ggplot2} based on brand colors defined
in the \verb{_brand.yml} file. These functions create discrete, continuous, or
binned scales with sequential, diverging, or qualitative color palettes
that match your brand identity.
}
\details{
\subsection{Path to \verb{_brand.yml}}{

\code{brandr} will always look for a \verb{_brand.yml} file in the root directory of
your project. If the file is not found, an error message will be displayed.
You can also set the path to the file manually using the
\code{\link[base:options]{options()}} function:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{options(BRANDR_BRAND_YML = "PATH_TO_BRAND.YML")
}\if{html}{\out{</div>}}
}

\subsection{Brand Color Scales}{

To control the colors for each brand color scale, assign the desired
\href{https://en.wikipedia.org/wiki/Web_colors}{hexadecimal} color codes in a
\code{\link[base:character]{character}} vector to the following options:
\itemize{
\item \code{BRANDR_COLOR_SEQUENTIAL}: For sequential color scales
\item \code{BRANDR_COLOR_DIVERGING}:  For diverging color scales
\item \code{BRANDR_COLOR_QUALITATIVE}: For qualitative color scales
}

You can use \code{\link[=get_brand_color]{get_brand_color()}} to get the hexadecimal
color codes from the \verb{_brand.yml} file.

Example:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{options(
  BRANDR_COLOR_SEQUENTIAL =
    get_brand_color(c("primary", "secondary")),
  BRANDR_COLOR_DIVERGING =
    get_brand_color(c("primary", "white", "secondary")),
  BRANDR_COLOR_QUALITATIVE =
    get_brand_color(c("primary", "secondary", "tertiary"))
)
}\if{html}{\out{</div>}}
}
}
\examples{
if (requireNamespace(
      c("palmerpenguins", "tidyr", "ggplot2"),
      quiet = TRUE
    )
   ) {
  library(ggplot2)
  library(palmerpenguins)
  library(tidyr)

  penguins |>
    drop_na(bill_length_mm, species) |>
    ggplot(aes(x = species, y = bill_length_mm, fill = species)) +
    geom_boxplot(outlier.color = get_brand_color("red")) +
    geom_jitter(width = 0.2, alpha = 0.1) +
    scale_fill_brand_d(alpha = 0.5) +
    labs(
      x = "Species",
      y = "Bill Length (mm)",
      fill = "Species"
    ) +
    theme_bw()
}

if (requireNamespace(
      c("palmerpenguins", "tidyr", "ggplot2"),
      quiet = TRUE
    )
   ) {
  library(ggplot2)
  library(palmerpenguins)
  library(tidyr)

  penguins |>
  drop_na(flipper_length_mm, species) |>
    ggplot(aes(x = flipper_length_mm, fill = species)) +
      geom_histogram(alpha = 0.5, bins = 30, position = "identity") +
      scale_fill_brand_d() +
      labs(
        x = "Flipper Length (mm)",
        y = "Frequency",
        fill = "Species"
      ) +
      theme_bw()
}

if (requireNamespace(
      c("palmerpenguins", "tidyr", "ggplot2"),
      quiet = TRUE
    )
   ) {
  library(ggplot2)
  library(palmerpenguins)
  library(tidyr)

  penguins |>
    drop_na(flipper_length_mm, body_mass_g, species) |>
    ggplot(
      aes(
        x = flipper_length_mm,
        y = body_mass_g,
        color = species,
        shape = species
      )
    ) +
    geom_point(size = 2) +
    geom_smooth(method = "lm", formula = y ~ x, se = FALSE) +
    scale_color_brand_d() +
    labs(
      x = "Flipper Length (mm)",
      y = "Body Mass (g)",
      color = "Species",
      shape = "Species"
    ) +
    theme_bw()
}

if (requireNamespace("ggplot2", quiet = TRUE)) {
  library(ggplot2)

  faithfuld |>
    ggplot(aes(waiting, eruptions, fill = density)) +
    geom_raster() +
    scale_fill_brand_b() +
    labs(
      x = "Waiting Time to Next Eruption (min)",
      y = "Eruption Time (min)",
      fill = "Density"
    ) +
    theme_bw()
}

if (requireNamespace("ggplot2", quiet = TRUE)) {
  library(ggplot2)
  library(hexbin)

  data.frame(x = runif(10000), y = runif(10000)) |>
    ggplot(aes(x, y)) +
    geom_hex() +
    coord_fixed() +
    scale_fill_brand_c() +
    labs(fill = "") +
    theme_bw()
}
}
\concept{ggplot2 functions.}
