% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme.R
\name{theme_brand_gt}
\alias{theme_brand_gt}
\title{Create a gt table theme using brand colors}
\usage{
theme_brand_gt(table, brand = NULL, background = NULL, foreground = NULL)
}
\arguments{
\item{table}{A gt table object to theme.}

\item{brand}{One of:
\itemize{
\item \code{NULL} (default): Automatically detect and read a _brand.yml file
\item A path to a brand.yml file or directory containing _brand.yml
\item A brand object (as returned by \code{read_brand_yml()} or \code{as_brand_yml()})
\item \code{FALSE}: Don't use a brand file; explicit colors must be provided
}}

\item{background}{The background color, defaults to \code{brand.color.background}.
If provided directly, this value can be a valid R color or the name of a
color in \code{brand.color} or \code{brand.color.palette}.}

\item{foreground}{The foreground color, defaults to \code{brand.color.foreground}.
If provided directly, this value can be a valid R color or the name of a
color in \code{brand.color} or \code{brand.color.palette}.}
}
\value{
Returns a themed gt table object.
}
\description{
Apply brand colors to a gt table.
}
\examples{
\dontshow{if (rlang::is_installed("gt") && getRversion() >= "4.5") withAutoprint(\{ # examplesIf}
brand <- as_brand_yml('
color:
  palette:
    black: "#1A1A1A"
    white: "#F9F9F9"
    orange: "#FF6F20"
  foreground: black
  background: white
  primary: orange')

library(gt)
theme_brand_gt(
  gt(head(palmerpenguins::penguins)),
  brand
)
\dontshow{\}) # examplesIf}
\dontshow{if (rlang::is_installed("gt") && getRversion() < "4.5") withAutoprint(\{ # examplesIf}
brand <- as_brand_yml('
color:
  palette:
    black: "#1A1A1A"
    white: "#F9F9F9"
    orange: "#FF6F20"
  foreground: black
  background: white
  primary: orange')

library(gt)
theme_brand_gt(
  gt(head(mtcars)),
  brand
)
\dontshow{\}) # examplesIf}
}
\seealso{
Other branded theming functions: 
\code{\link{theme_brand_flextable}()},
\code{\link{theme_brand_ggplot2}()},
\code{\link{theme_brand_plotly}()},
\code{\link{theme_brand_thematic}()}
}
\concept{branded theming functions}
