% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary_kcca}
\alias{summary_kcca}
\title{Print information of object generated by permkCCA_multipleRegion function}
\usage{
summary_kcca(kcca_object, significance = 0.05, patientID = 1,
  saveFormat = "markdown", threshold = 0.2)
}
\arguments{
\item{kcca_object}{the result generated by permkCCA_multipleRegion function.
This argument can also accept an adjacent matrix containing information of connectinity network.
This matrix must have row names or column names, which define the region index. For example,
column names with 1, 5, 10 means region 1, 5 and 10.}

\item{significance}{significance level of hypothesis testing}

\item{patientID}{if you have more than one patient in the kcca_object,
you need to specify which patient you would like to summarize.
If you have only one patient, then the default patientID is 1.}

\item{saveFormat}{a character string; possible values are excel,
latex, html, markdown, etc.; it can also be set in the global option
knitr.table.format; if format is a function, it must return a character
string. If you specify saveFormat="group", then this function can help you summarize
group level information for all patients.}

\item{threshold}{the threshold for significance of percentage of connection
(if percentage exceeds threhold, then the region pair is significant).
Typically, it can be 15-30\%.}
}
\description{
This function can print information of kcca object for single object.
}
\details{
After you obtained results from permkCCA_multipleRegion() function,
there are two ways to summarize and save information of
kcca objects at group level (i.e. construct region-level conenctivity network):\cr
(1) for each patient i, you can spcify patientID = i and saveFormat="excel",
and then store the output in csv files. The generated csv files have 7 columns:
row number, index1, index2, region1, region2, pvalue, indicator of significance,
and count flag (always 1). See example 1 for more information. \cr
(2) if you do not want save information in csv files, you can specify
saveFormat="group" abd then this function can help you summarize group
level information for all patients. The output variables have 7 columns: row number, index1,
index2, region1, region2, pvalue, indicator of significance, and count flag (always 1).\cr
If you want to save data as other format such as latex, you can directly copy
the generated latex code to your tex file. See example 3 for more information.\cr
Note that if returned object has length 0 (i.e. no connection), then warning message will be generated.
}
\examples{
\donttest{
#It will take more than 10 s to run
#write data into temp file
filePath <- tempdir()
#the nii.gz fMRI imaging file is created (toy example)
oro.nifti::writeNIfTI(brainKCCA::input_img, paste(filePath, "/",  "temp", sep=""))
#read fMRI data
testcase1 <- nii2RData(niiFile1 = "temp", resolution = "3mm", imgPath = filePath)
result1<-permkCCA_multipleRegion(imageDat = testcase1, region = c(1,5,10))
summary_kcca(result1)
}
}
\author{
Xubo Yue, Chia-Wei Hsu (tester), Jian Kang (maintainer)
}
