% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.baQCAtest.R
\name{summary.baQCAtest}
\alias{summary.baQCAtest}
\title{Summarize Results of baQCA}
\usage{
\method{summary}{baQCAtest}(object, ...)
}
\arguments{
\item{object}{Object returned by \code{\link{baQCA}}.}

\item{...}{Additional parameters to pass on.}
}
\value{
Matrix of values for percent of simulations returning result from random data, along with confidence interval.
}
\description{
Displays results of baQCA.
}
\examples{
qca.data <- rallies[,8:13]
rownames(qca.data)<-rownames(rallies)
truth<-QCA::truthTable(qca.data,outcome="P",sort.by="incl",incl.cut1=0.85,n.cut=1,show.cases=TRUE)
mod1 <- QCA::minimize(truth,details=TRUE,show.cases=TRUE)

test <- baQCA(mod1,sim=1) 
summary(test)
}
