% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxr_s3_classes.R
\name{boxr_S3_classes}
\alias{boxr_S3_classes}
\title{boxr S3 Classes}
\description{
boxr implements a series of S3 classes to manage the data returned by the
Box API. These classes are built on \code{list}; if you wish to access the
information directly, you can use \code{unclass(x)}.
}
\details{
\strong{\code{boxr_file_reference}}
\itemize{
\item describes a file created, modified, or deleted at Box.
\item returned by \code{\link[=box_ul]{box_ul()}}, \code{\link[=box_save]{box_save()}}, \code{\link[=box_delete_file]{box_delete_file()}}, etc.
\item available methods: \code{\link[=print]{print()}}.
}

\strong{\code{boxr_folder_reference}}
\itemize{
\item describes a folder created or deleted at Box.
\item returned by \code{\link[=box_dir_create]{box_dir_create()}}, \code{\link[=box_delete_folder]{box_delete_folder()}}.
\item available methods: \code{\link[=print]{print()}}.
}

\strong{\code{boxr_dir_wide_operation_result}}
\itemize{
\item describes the result of a directory-wide operation.
\item returned by \code{\link[=box_fetch]{box_fetch()}} and \code{\link[=box_push]{box_push()}}.
\item available methods: \code{\link[=print]{print()}}, \code{\link[=summary]{summary()}}.
}

\strong{\code{boxr_object_list}}
\itemize{
\item describes a collection of files at Box.
\item returned by \code{\link[=box_ls]{box_ls()}}, \code{\link[=box_search]{box_search()}}, and related functions.
\item available methods: \code{\link[=print]{print()}}, \code{\link[=as.data.frame]{as.data.frame()}}.
}

\strong{\code{boxr_dir_comparison}}
\itemize{
\item describes the difference between directories.
\item returned by the internal function \code{\link[=box_dir_diff]{box_dir_diff()}}.
\item available methods: \code{\link[=print]{print()}}, \code{\link[=summary]{summary()}}.
}

\strong{\code{boxr_collab}}
\itemize{
\item describes a collaboration (sharing permission).
\item returned by \code{\link[=box_collab_create]{box_collab_create()}}.
\item available methods: \code{\link[=print]{print()}}, \code{\link[=as.data.frame]{as.data.frame()}}, \code{\link[tibble:as_tibble]{tibble::as_tibble()}}.
}

\strong{\code{boxr_collab_list}}
\itemize{
\item describes a collection of collaborations.
\item returned by \code{\link[=box_collab_get]{box_collab_get()}}.
\item available methods: \code{\link[=print]{print()}}, \code{\link[=as.data.frame]{as.data.frame()}}, \code{\link[tibble:as_tibble]{tibble::as_tibble()}}.
}

\strong{\code{boxr_comment}}
\itemize{
\item describes a comment on a file.
\item returned by \code{\link[=box_comment_create]{box_comment_create()}}.
\item available methods: \code{\link[=print]{print()}}, \code{\link[=as.data.frame]{as.data.frame()}}, \code{\link[tibble:as_tibble]{tibble::as_tibble()}}.
}

\strong{\code{boxr_comment_list}}
\itemize{
\item describes a collection of comments on a file.
\item returned by \code{\link[=box_comment_get]{box_comment_get()}}.
\item available methods: \code{\link[=print]{print()}}, \code{\link[=as.data.frame]{as.data.frame()}}, \code{\link[tibble:as_tibble]{tibble::as_tibble()}}.
}

\strong{\code{boxr_version_list}}
\itemize{
\item describes a collection of version information on a file.
\item returned by \code{\link[=box_version_api]{box_version_api()}}.
\item available methods: \code{\link[=print]{print()}}, \code{\link[=as.data.frame]{as.data.frame()}}, \code{\link[tibble:as_tibble]{tibble::as_tibble()}}.
}
}
