% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxr_collab.R
\name{box_collab_create}
\alias{box_collab_create}
\title{Create Box collaboration}
\usage{
box_collab_create(
  dir_id = NULL,
  user_id = NULL,
  file_id = NULL,
  group_id = NULL,
  login = NULL,
  role = "editor",
  can_view_path = FALSE
)
}
\arguments{
\item{dir_id}{\code{numeric} or \code{character}, folder ID at Box.}

\item{user_id}{\code{character} ID for Box user-account to invite.}

\item{file_id}{\code{numeric} or \code{character}, file ID at Box.}

\item{group_id}{\code{character} ID for Box group-account to invite.}

\item{login}{\code{character} email address of account to invite, if specified
will be used instead of \code{user_id}.}

\item{role}{\code{character} role of the collaborator; default is \code{"viewer"}.}

\item{can_view_path}{\code{logical} indicates to allow the collaborator to
navigate parent-folders at Box.}
}
\value{
Object with S3 class \code{\link[=boxr_S3_classes]{boxr_collab}}.
}
\description{
Although this function can be used in all sorts of situations, it can be
particularly useful in setting up a workflow with a service-account:
\itemize{
\item If you are authenticated as a user, using \code{\link[=box_auth]{box_auth()}}, you can invite
the service account to collaborate on a folder in your \emph{user} filespace.
In this case, the shared folder will appear in the service-account
filespace.
\item If you are authenticated as the service-account using
\code{\link[=box_auth_service]{box_auth_service()}}, you can invite your \emph{user-account} to collaborate.
In this case, the shared folder will appear in your user file-space.
}

Once you issue an invitation to create a collaboration, you cannot change it,
e.g. you cannot change the \code{role} from \code{"viewer"} to \code{"co-owner"}.
However, you can delete the collaboration, then issue a \emph{new} invitation.
To delete a collaboration, use \code{\link[=box_collab_delete]{box_collab_delete()}}. To check a Box folder ID or file ID
for existing collaborations, use \code{\link[=box_collab_get]{box_collab_get()}}.
You can also use the Box web-portal to manage collaborations.

The default \code{role}, i.e. permission level, for an invitation
is \code{"editor"}. Legal values for \code{role} are \code{"editor"}, \code{"viewer"},
\code{"previewer"}, \code{"uploader"}, \code{"previewer uploader"}, \code{"viewer uploader"},
\code{"co-owner"}, \code{"owner"}.
}
\details{
To use this function, you must provide exactly one of: \code{dir_id} or \code{file_id},
to specify what you want to share, and exactly one of: \code{user_id},
\code{group_id}, or \code{login} (email address), to specify the account you want to
share it with.

While authenticated from the host account, the one that will issue the
invitation, you can use \code{box_ls()} and \code{box_setwd()} to get the \code{dir_id}
or \code{file_id} for the item you want to share. If the host-account is the
user-account, you can also use the web-portal to find the \code{dir_id} or
\code{file-id}. If the host account is the service-account, you can use the Box
\href{https://app.box.com/master/content}{content-portal} to find this.

A user can find their \code{user_id} using the Box web-portal. As well, when
you authenticate using boxr, the \code{user_id} is included in the login
message. Thus, you can use \code{box_auth_service()} to find out the \code{user_id}
for a given service-account.

This returns an object with S3 class \code{\link[=boxr_S3_classes]{boxr_collab}};
this is a list containing the response from the API. You can use
\code{as_tibble()} or \code{as.data.frame()} on this return-object to convert to
a tibble or data frame.
}
\seealso{
\code{\link[=box_auth]{box_auth()}}, \code{\link[=box_auth_service]{box_auth_service()}}
}
