% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitDistributionsToCIs.R
\name{getPoisFromCI}
\alias{getPoisFromCI}
\title{Find the best-fit Poisson distribution for a given confidence interval.}
\usage{
getPoisFromCI(qLow, qUpp, alpha = 0.05, initPars = 5, maxiter = 1000)
}
\arguments{
\item{qLow}{The observed lower quantile.}

\item{qUpp}{The observed upper quantile.}

\item{alpha}{The confidence level; i.e. the desired coverage is 1-alpha. Defaults to 0.05.}

\item{initPars}{A vector of length 1 giving the initial parameter value (rate parameter) to start the optimisation; defaults to 5.}

\item{maxiter}{Maximum number of iterations for \code{optim}. Defaults to 1e3. Set to higher values if convergence problems are reported.}
}
\value{
A list with 5 elements:
\item{r}{The sampling function.}
\item{d}{The probability mass function.}
\item{p}{The distribution function.}
\item{q}{The quantile function.}
\item{pars}{A single number giving the rate parameter for the best-fit Poisson distribution (\code{lambda} as in \code{\link{rpois}}, \code{\link{dpois}}, \code{\link{ppois}}, \code{\link{qpois}}).}
}
\description{
Finds the best-fit Poisson distribution for a given confidence interval; returns the corresponding probability mass, distribution, quantile and sampling functions.
The use of this function within the bootComb package is limited: this is a discrete distribution but since users provide confidence intervals, the corresponding parameters will be best approximated by continuous distributions.
}
\examples{
n<-getPoisFromCI(qLow=9,qUpp=22)
print(n$par) # the fitted parameter value (lambda)
n$r(10) # 10 random values from the fitted Poisson distribution
n$d(6) # the probability mass at x=6 for the Poisson distribution
n$p(7) # the cumulative probability at x=7 for the fitted Poisson distribution
n$q(c(0.25,0.5,0.75)) # the 25th, 50th (median) and 75th percentiles of the fitted distribution
x<-0:40
y<-n$d(x)
barplot(height=y,names.arg=x,xlab="",ylab="probability mass") # bar plot of the fitted Poisson pmf

}
\seealso{
\code{\link{identifyPoisPars}}, \code{\link{optim}}, \code{\link{dpois}}
}
