% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_test.R
\name{boot_t_test}
\alias{boot_t_test}
\alias{boot_t_test.default}
\alias{boot_t_test.formula}
\alias{boot_t_test.data.frame}
\alias{boot_t_test.matrix}
\title{Bootstrap t-Test}
\usage{
boot_t_test(x, ...)

\method{boot_t_test}{default}(
  x,
  y = NULL,
  alternative = c("two.sided", "less", "greater"),
  mu = 0,
  paired = FALSE,
  var.equal = FALSE,
  conf.level = 0.95,
  R = 9999,
  type = "stud",
  ...
)

\method{boot_t_test}{formula}(formula, data, subset, na.action, ...)

\method{boot_t_test}{data.frame}(x, formula, ...)

\method{boot_t_test}{matrix}(x, formula, ...)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{...}{Additional arguments passed to \code{boot}, such as \code{parallel} for parallel computations. See \code{?boot::boot} for details.}

\item{y}{an optional (non-empty) numeric vector of data values.}

\item{alternative}{a character string specifying the alternative
    hypothesis, must be one of \code{"two.sided"} (default),
    \code{"greater"} or \code{"less"}.  You can specify just the initial
    letter.}

\item{mu}{a number indicating the true value of the mean (or
    difference in means if you are performing a two sample test).}

\item{paired}{a logical indicating whether you want a paired
    t-test.}

\item{var.equal}{a logical variable indicating whether to treat the
    two variances as being equal. If \code{TRUE} then the pooled
    variance is used to estimate the variance otherwise the Welch
    (or Satterthwaite) approximation to the degrees of freedom is used.}

\item{conf.level}{confidence level of the interval.}

\item{R}{The number of bootstrap replicates. The default is 9999.}

\item{type}{A vector of character strings representing the type of interval to base the test on. The value should be one of "norm", "basic", "bca", perc", and "stud" (the default).}

\item{formula}{a formula of the form \code{lhs ~ rhs} where \code{lhs}
    is a numeric variable giving the data values and \code{rhs} either 
    \code{1} for a one-sample or paired test or a factor
    with two levels giving the corresponding groups. If \code{lhs} is of 
    class \code{"\link[stats]{Pair}"} and \code{rhs} is \code{1}, a paired test
    is done, see Examples.}

\item{data}{an optional matrix or data frame (or similar: see
    \code{\link[stats]{model.frame}}) containing the variables in the
    formula \code{formula}.  By default the variables are taken from
    \code{environment(formula)}.}

\item{subset}{an optional vector specifying a subset of observations
    to be used.}

\item{na.action}{a function which indicates what should happen when
    the data contain \code{\link{NA}}s.}
}
\value{
A list with class \code{"htest"})
containing the following components:
\item{statistic}{the value of the t-statistic.}
\item{R}{the number of bootstrap replicates used.}
\item{p.value}{the bootstrap p-value for the test.}
\item{conf.int}{a bootstrap confidence interval for the mean appropriate to the
specified alternative hypothesis.}
\item{estimate}{the estimated mean or difference in means depending on
whether it was a one-sample test or a two-sample test.}
\item{null.value}{the specified hypothesized value of the mean or mean
difference depending on whether it was a one-sample test or a
two-sample test.}
\item{alternative}{a character string describing the alternative
hypothesis.}
\item{method}{a character string indicating what type of t-test was
performed.}
\item{data.name}{a character string giving the name(s) of the data.}
}
\description{
Performs one- and two-sample bootstrap t-tests and computes the corresponding bootstrap confidence interval.
}
\details{
p-values can be computed by inverting the corresponding confidence intervals, as described in Section 14.2 of Thulin (2024) and Section 3.12 in Hall (1992). This function computes p-values for the t-test in this way. The approach relies on the fact that:
\itemize{
\item the p-value of the two-sided test for the parameter theta is the smallest alpha such that theta is not contained in the corresponding 1-alpha confidence interval,
\item for a test of the parameter theta with significance level alpha, the set of values of theta that aren't rejected by the two-sided test (when used as the null hypothesis) is a 1-alpha confidence interval for theta.
Consequently, the p-value will be consistent with the confidence interval, in the sense that the null hypothesis is rejected if and only if the null parameter values is not contained in the confidence interval.
}
}
\examples{
# Generate example data:
# x is the variable of interest
# y is the grouping variable
example_data <- data.frame(x = rnorm(40), y = rep(c(1,2), 20))

# Two-sample (Welch) test:
boot_t_test(x ~ y, data = example_data, R = 999)

# Two-sample (Welch) test using the pipe:
example_data |> boot_t_test(x ~ y, R = 999)

# With a directed alternative hypothesis:
example_data |> boot_t_test(x ~ y, R = 999, alternative = "greater")

# One-sample test:
boot_t_test(example_data$x, R = 999)

# One-sample test using the pipe:
example_data |> boot_t_test(x ~ 1, R = 999)

# With a directed alternative hypothesis:
example_data |> boot_t_test(x ~ 1, R = 999, mu = 0.5, alternative = "less")

# Paired test:
boot_t_test(example_data$x[example_data$y==1],
            example_data$x[example_data$y==2],
            paired = TRUE, R = 999)

# Paired test using the pipe (after reshaping to wide format):
example_data$id <- rep(1:20, rep(2, 20))
example_data2 <- reshape(example_data, direction = "wide",
                         idvar = "id", timevar = "y")
example_data2 |> boot_t_test(Pair(x.1, x.2) ~ 1)
}
\references{
\insertRef{hall92}{boot.pval}
\insertRef{thulin21}{boot.pval}
}
\seealso{
\code{\link[=boot_median_test]{boot_median_test()}} for bootstrap tests for medians, \code{\link[=boot_summary]{boot_summary()}} for bootstrap tests for coefficients of regression models.
}
