% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{update.boostrq}
\alias{update.boostrq}
\title{Update and Re-fit a boostrq model}
\usage{
\method{update}{boostrq}(object, weights, oobweights, risk, ...)
}
\arguments{
\item{object}{a boostrq object}

\item{weights}{(optional) a numeric vector indicating which weights to used in the fitting process
(default: all observations are equally weighted, with 1).}

\item{oobweights}{an additional vector of out-of-bag weights, which is used for the out-of-bag risk.}

\item{risk}{string indicating how the empirical risk should be computed for each boosting iteration.
inbag leads to risks computed for the learning sample (i.e. observations with non-zero weights),
oobag to risks based on the out-of-bag (i.e. observations with non-zero oobagweights).}

\item{...}{additional arguments passed to callies}
}
\value{
a re-fitted boostrq model
}
\description{
Update and Re-fit a boostrq model
}
\examples{
boosted.rq <-
boostrq(
 formula = mpg ~ brq(cyl * hp) + brq(am + wt),
 data = mtcars,
 mstop = 200,
 nu = 0.1,
 tau = 0.5
)

update(
boosted.rq,
weights = c(rep(1, 30), 0, 0),
oobweights = c(rep(0, 30), 1,1),
risk = "oobag"
)

}
