% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{coef.boostrq}
\alias{coef.boostrq}
\title{estimated coefficients of boosting regression quantiles}
\usage{
\method{coef}{boostrq}(object, which = NULL, aggregate = "sum", ...)
}
\arguments{
\item{object}{object of class boostrq}

\item{which}{a subset of base-learners}

\item{aggregate}{a character specifying how to aggregate coefficients of
single base learners. The default returns the coefficient for the final number
of boosting iterations. "cumsum" returns a list with matrices (one per base-learner)
with the cumulative coefficients for all iterations. "none" returns a list of
matrices where the jth columns of the respective matrix contains coefficients
of the base-learner of the jth boosting iteration.v "sum_aggr" ...}

\item{...}{additional arguments passed to callies}
}
\value{
coef extracts the regression coefficients of the fitted boostrq model.
}
\description{
estimated coefficients of boosting regression quantiles
}
\examples{
boosted.rq <-
boostrq(
 formula = mpg ~ brq(cyl * hp) + brq(am + wt),
 data = mtcars,
 mstop = 200,
 nu = 0.1,
 tau = 0.5
)

coef(boosted.rq, aggregate = "cumsum")

}
