% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca.R
\name{pca_ind_contrib}
\alias{pca_ind_contrib}
\title{Compute individual contributions}
\usage{
pca_ind_contrib(
  ind_coords,
  eigs,
  weighted_row = rep(1, nrow(ind_coords))/nrow(ind_coords)
)
}
\arguments{
\item{ind_coords}{individual coordinates}

\item{eigs}{eigs computed by \code{pca_eigen} or \code{pca_weighted_eigen}}

\item{weighted_row}{row weights}
}
\value{
A dataframe of individual contributions.
}
\description{
Return individual contributions for each principal component
}
\details{
If you want to compute the contributions of the individuals to the principal
components, you have to change the weighted_col argument to rep(1, nrow(ind_cos2)).
}
\examples{
library(booklet)

eigs <- iris[, -5] |>
  pca_standardize_norm() |>
  pca_weighted_eigen()

eigs |>
  pca_ind_coords() |>
  pca_ind_contrib(eigs) |>
  head()
}
