% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skewNormal.R
\name{SkewNormal}
\alias{SkewNormal}
\title{Skew normal distribution}
\description{
A R6 class to represent a skew normal distribution.
}
\details{
See \href{https://en.wikipedia.org/wiki/Skew_normal_distribution}{Wikipedia}.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{xi}}{Get or set the value of \code{xi}.}

\item{\code{omega}}{Get or set the value of \code{omega}.}

\item{\code{alpha}}{Get or set the value of \code{alpha}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SkewNormal-new}{\code{SkewNormal$new()}}
\item \href{#method-SkewNormal-d}{\code{SkewNormal$d()}}
\item \href{#method-SkewNormal-p}{\code{SkewNormal$p()}}
\item \href{#method-SkewNormal-q}{\code{SkewNormal$q()}}
\item \href{#method-SkewNormal-r}{\code{SkewNormal$r()}}
\item \href{#method-SkewNormal-mean}{\code{SkewNormal$mean()}}
\item \href{#method-SkewNormal-mode}{\code{SkewNormal$mode()}}
\item \href{#method-SkewNormal-sd}{\code{SkewNormal$sd()}}
\item \href{#method-SkewNormal-variance}{\code{SkewNormal$variance()}}
\item \href{#method-SkewNormal-skewness}{\code{SkewNormal$skewness()}}
\item \href{#method-SkewNormal-kurtosis}{\code{SkewNormal$kurtosis()}}
\item \href{#method-SkewNormal-kurtosisExcess}{\code{SkewNormal$kurtosisExcess()}}
\item \href{#method-SkewNormal-clone}{\code{SkewNormal$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SkewNormal-new"></a>}}
\if{latex}{\out{\hypertarget{method-SkewNormal-new}{}}}
\subsection{Method \code{new()}}{
New skew normal distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SkewNormal$new(xi, omega, alpha)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xi}}{location parameter}

\item{\code{omega}}{scale parameter, \code{>0}}

\item{\code{alpha}}{shape parameter}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{SkewNormal} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SkewNormal-d"></a>}}
\if{latex}{\out{\hypertarget{method-SkewNormal-d}{}}}
\subsection{Method \code{d()}}{
Density function of the skew normal distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SkewNormal$d(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{numeric vector}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The density evaluated at \code{x}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SkewNormal-p"></a>}}
\if{latex}{\out{\hypertarget{method-SkewNormal-p}{}}}
\subsection{Method \code{p()}}{
Cumulative distribution function of the skew normal
  distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SkewNormal$p(q, lower = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{q}}{numeric vector of quantiles}

\item{\code{lower}}{Boolean, whether to deal with the lower tail}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The cumulative probabilities corresponding to \code{q}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SkewNormal-q"></a>}}
\if{latex}{\out{\hypertarget{method-SkewNormal-q}{}}}
\subsection{Method \code{q()}}{
Quantile function of the skew normal distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SkewNormal$q(p, lower = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{p}}{numeric vector of probabilities}

\item{\code{lower}}{Boolean, whether to deal with the lower tail}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The quantiles corresponding to \code{p}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SkewNormal-r"></a>}}
\if{latex}{\out{\hypertarget{method-SkewNormal-r}{}}}
\subsection{Method \code{r()}}{
Sampling from the skew normal distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SkewNormal$r(n)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{number of simulations}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric vector of length \code{n}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SkewNormal-mean"></a>}}
\if{latex}{\out{\hypertarget{method-SkewNormal-mean}{}}}
\subsection{Method \code{mean()}}{
Mean of the skew normal distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SkewNormal$mean()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The mean of the skew normal distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SkewNormal-mode"></a>}}
\if{latex}{\out{\hypertarget{method-SkewNormal-mode}{}}}
\subsection{Method \code{mode()}}{
Mode of the skew normal distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SkewNormal$mode()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The mode of the skew normal distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SkewNormal-sd"></a>}}
\if{latex}{\out{\hypertarget{method-SkewNormal-sd}{}}}
\subsection{Method \code{sd()}}{
Standard deviation of the skew normal distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SkewNormal$sd()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The standard deviation of the skew normal distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SkewNormal-variance"></a>}}
\if{latex}{\out{\hypertarget{method-SkewNormal-variance}{}}}
\subsection{Method \code{variance()}}{
Variance of the skew normal distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SkewNormal$variance()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The variance of the skew normal distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SkewNormal-skewness"></a>}}
\if{latex}{\out{\hypertarget{method-SkewNormal-skewness}{}}}
\subsection{Method \code{skewness()}}{
Skewness of the skew normal distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SkewNormal$skewness()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The skewness of the skew normal distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SkewNormal-kurtosis"></a>}}
\if{latex}{\out{\hypertarget{method-SkewNormal-kurtosis}{}}}
\subsection{Method \code{kurtosis()}}{
Kurtosis of the skew normal distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SkewNormal$kurtosis()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The kurtosis of the skew normal distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SkewNormal-kurtosisExcess"></a>}}
\if{latex}{\out{\hypertarget{method-SkewNormal-kurtosisExcess}{}}}
\subsection{Method \code{kurtosisExcess()}}{
Kurtosis excess of the skew normal distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SkewNormal$kurtosisExcess()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The kurtosis excess of the skew normal distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SkewNormal-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SkewNormal-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SkewNormal$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
