% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexp.R
\name{Hyperexponential}
\alias{Hyperexponential}
\title{Hyperexponential distribution}
\description{
A R6 class to represent a hyperexponential distribution.
}
\details{
See \href{https://en.wikipedia.org/wiki/Hyperexponential_distribution}{Wikipedia}.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{probs}}{Get or set the value of \code{probs}.}

\item{\code{rates}}{Get or set the value of \code{rates}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Hyperexponential-new}{\code{Hyperexponential$new()}}
\item \href{#method-Hyperexponential-d}{\code{Hyperexponential$d()}}
\item \href{#method-Hyperexponential-p}{\code{Hyperexponential$p()}}
\item \href{#method-Hyperexponential-q}{\code{Hyperexponential$q()}}
\item \href{#method-Hyperexponential-r}{\code{Hyperexponential$r()}}
\item \href{#method-Hyperexponential-mean}{\code{Hyperexponential$mean()}}
\item \href{#method-Hyperexponential-mode}{\code{Hyperexponential$mode()}}
\item \href{#method-Hyperexponential-sd}{\code{Hyperexponential$sd()}}
\item \href{#method-Hyperexponential-variance}{\code{Hyperexponential$variance()}}
\item \href{#method-Hyperexponential-skewness}{\code{Hyperexponential$skewness()}}
\item \href{#method-Hyperexponential-kurtosis}{\code{Hyperexponential$kurtosis()}}
\item \href{#method-Hyperexponential-kurtosisExcess}{\code{Hyperexponential$kurtosisExcess()}}
\item \href{#method-Hyperexponential-clone}{\code{Hyperexponential$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Hyperexponential-new"></a>}}
\if{latex}{\out{\hypertarget{method-Hyperexponential-new}{}}}
\subsection{Method \code{new()}}{
New hyperexponential distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Hyperexponential$new(probs, rates)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{probs}}{probabilities (weights), a vector of positive numbers}

\item{\code{rates}}{rate parameters, vector of positive numbers of the same
length as the \code{probs} vector}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Hyperexponential} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Hyperexponential-d"></a>}}
\if{latex}{\out{\hypertarget{method-Hyperexponential-d}{}}}
\subsection{Method \code{d()}}{
Density function of the hyperexponential distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Hyperexponential$d(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{vector of positive numbers}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The density evaluated at \code{x}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Hyperexponential-p"></a>}}
\if{latex}{\out{\hypertarget{method-Hyperexponential-p}{}}}
\subsection{Method \code{p()}}{
Cumulative distribution function of the hyperexponential
  distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Hyperexponential$p(q, lower = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{q}}{numeric vector of quantiles}

\item{\code{lower}}{Boolean, whether to deal with the lower tail}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The cumulative probabilities corresponding to \code{q}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Hyperexponential-q"></a>}}
\if{latex}{\out{\hypertarget{method-Hyperexponential-q}{}}}
\subsection{Method \code{q()}}{
Quantile function of the hyperexponential distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Hyperexponential$q(p, lower = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{p}}{numeric vector of probabilities}

\item{\code{lower}}{Boolean, whether to deal with the lower tail}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The quantiles corresponding to \code{p}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Hyperexponential-r"></a>}}
\if{latex}{\out{\hypertarget{method-Hyperexponential-r}{}}}
\subsection{Method \code{r()}}{
Sampling from the hyperexponential distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Hyperexponential$r(n)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{number of simulations}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric vector of length \code{n}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Hyperexponential-mean"></a>}}
\if{latex}{\out{\hypertarget{method-Hyperexponential-mean}{}}}
\subsection{Method \code{mean()}}{
Mean of the hyperexponential distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Hyperexponential$mean()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The mean of the hyperexponential distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Hyperexponential-mode"></a>}}
\if{latex}{\out{\hypertarget{method-Hyperexponential-mode}{}}}
\subsection{Method \code{mode()}}{
Mode of the hyperexponential distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Hyperexponential$mode()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The mode of the hyperexponential distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Hyperexponential-sd"></a>}}
\if{latex}{\out{\hypertarget{method-Hyperexponential-sd}{}}}
\subsection{Method \code{sd()}}{
Standard deviation of the hyperexponential distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Hyperexponential$sd()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The standard deviation of the hyperexponential distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Hyperexponential-variance"></a>}}
\if{latex}{\out{\hypertarget{method-Hyperexponential-variance}{}}}
\subsection{Method \code{variance()}}{
Variance of the hyperexponential distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Hyperexponential$variance()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The variance of the hyperexponential distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Hyperexponential-skewness"></a>}}
\if{latex}{\out{\hypertarget{method-Hyperexponential-skewness}{}}}
\subsection{Method \code{skewness()}}{
Skewness of the hyperexponential distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Hyperexponential$skewness()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The skewness of the hyperexponential distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Hyperexponential-kurtosis"></a>}}
\if{latex}{\out{\hypertarget{method-Hyperexponential-kurtosis}{}}}
\subsection{Method \code{kurtosis()}}{
Kurtosis of the hyperexponential distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Hyperexponential$kurtosis()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The kurtosis of the hyperexponential distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Hyperexponential-kurtosisExcess"></a>}}
\if{latex}{\out{\hypertarget{method-Hyperexponential-kurtosisExcess}{}}}
\subsection{Method \code{kurtosisExcess()}}{
Kurtosis excess of the hyperexponential distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Hyperexponential$kurtosisExcess()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The kurtosis excess of the hyperexponential distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Hyperexponential-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Hyperexponential-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Hyperexponential$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
