% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jackFunc.R
\name{jackFunc}
\alias{jackFunc}
\title{Jackknife Variance Function}
\usage{
jackFunc(func, ...)
}
\arguments{
\item{func}{The function used to compute the statistic on each sample.}

\item{...}{Optional additional arguments for the \code{func} function.}
}
\value{
Returns an object, which is a function.
}
\description{
Creates a vector-valued function for computing both the statistic defined by \code{func}
and the estimated jackknife variance of the statistic.
}
\details{
The \code{jackFunc} function constructs a new function that, when applied to a data sample,
calculates both the statistic specified by \code{func} and its associated jackknife variance.
This newly created function is useful in generic bootstrap procedures, particularly
for constructing bootstrap-t confidence intervals.
}
\examples{
# Create a function to compute the empirical skewness
func <- function(x) { mean((x - mean(x))^3) / (mean((x - mean(x))^2)^(3/2)) }
x <- rnorm(100)
# Create a function to compute the empirical skewness and its variance
jf <- jackFunc(func)
# Bootstrapping of the skewness and its variance allows to construct 
# bootstrap-t confidence intervals
boo1 <- boots(x, jf, 299)
confint(boo1, method="all")
}
\references{
Bertail, P. and Dudek, A. (2025). \emph{Bootstrap for
Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek) - submitted.

Efron, B. (1979). Bootstrap methods: another look at the jackknife.
\emph{Ann. Statist.}, \bold{7}, 1-26.

Gray, H., Schucany, W. and Watkins, T. (1972). \emph{The Generalized Jackknife Statistics}.
Marcel Dekker, New York.

Quenouille, M.H. (1949). Approximate tests of correlation in time-series.
\emph{J. Roy. Statist. Soc., Ser. B}, \bold{11}, 68-84.
}
\seealso{
\code{\link{jackVar}},
\code{\link{boots}},
\code{\link{jackVarBlock}},
\code{\link{jackFuncBlock}},
\code{\link{jackFuncRegen}}.
}
\keyword{"Statistical}
\keyword{"Variance}
\keyword{Jackknife}
\keyword{Resampling}
\keyword{analysis"}
\keyword{estimation"}
