% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freqboot.R
\name{freqboot}
\alias{freqboot}
\title{Frequency Domain Bootstrap}
\usage{
freqboot(x, XI, g, B, kernel = "normal", bandwidth)
}
\arguments{
\item{x}{A vector or time series.}

\item{XI}{A list of functions defined on the interval \eqn{[0, \pi]}.}

\item{g}{A numeric function accepting \code{length(XI)} arguments, used to compute
the statistic of interest.}

\item{B}{A positive integer; the number of bootstrap replications.}

\item{kernel}{A character string specifying the smoothing kernel. The valid values
are:
\itemize{
\item \code{"normal"} - default,
\item \code{"epanechnikov"},
\item \code{"box"} - rectangular kernel.
}}

\item{bandwidth}{A real number; the kernel bandwidth smoothing parameter.
If unspecified, an optimal value is computed using formula \eqn{sd(x)*n^(-1/3)},
which is smaller than the Silverman's rule-of-thumb bandwidth.}
}
\value{
Returns an object of class \code{boodd}.
}
\description{
Implements the Frequency Domain Bootstrap (FDB) for time series data.
}
\details{
The input series \code{x} is assumed to be a sample from a real-valued, zero-mean,
stationary time series. The \code{XI} argument consists of functions \eqn{\xi_i} used
to define linear functionals of the spectral density, say
\eqn{A(\xi,f)=\int\xi_i(\omega)f(\omega)d\omega}. The statistic estimates \eqn{T(f)=g(A(\xi,f))}.
The spectral density is estimated by smoothing the periodogram of the series, with
the smoothing kernel specified by \code{kernel} and the smoothing parameter
\code{bandwidth}.
The FDB consists in resampling periodogram ordinates standardized by the spectral density
estimates to recompute the bootstrap values of the statistics of interest.
}
\examples{
set.seed(123)
n <- 120
x <- arima.sim(list(order=c(1,0,0),ar=0.7),n=n)
B <- 999
one <- function(x) {1}
XI <- list(cos,one)
g <- function(x,y) {return(x/y)}
# This gives an estimate for the autocorrelation of order 1
boo = freqboot(x,XI,g,B,"normal")
plot(boo)
}
\references{
Bertail, P. and Dudek, A. (2025). \emph{Bootstrap for
Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek) - submitted.

Hurvich, C. M. and Zeger, S. L. (1987). Frequency domain bootstrap
methods for time series, Technical Report 87-115, Graduate School of Business
Administration, New York Univ.

Bertail, P. and Dudek, A. (2021). Consistency of the Frequency Domain
Bootstrap for differentiable functionals, \emph{Electron. J. Statist.}, \bold{15}, 1-36.

Lahiri, S.N. (2003). \emph{Resampling Methods for Dependent Data}. Springer,
New York.
}
\seealso{
\code{\link{aidedboot}}, \code{\link{func_fdb}}, \code{\link{per_boo}},
\code{\link{tft_boot}}.
}
\keyword{"Frequency}
\keyword{"Spectral}
\keyword{"Stationary}
\keyword{Bootstrap"}
\keyword{Domain}
\keyword{analysis"}
\keyword{series"}
\keyword{time}
