% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint.boodd.R
\name{confint.boodd}
\alias{confint.boodd}
\title{Calculate Confidence Intervals for \code{boodd} Objects.}
\usage{
\method{confint}{boodd}(
  object,
  parm = NULL,
  level = 0.95,
  method = c("perc", "bperc", "aboot", "tboot", "tsymboot", "all"),
  recenter,
  ...
)
}
\arguments{
\item{object}{An object of class \code{boodd}.}

\item{parm}{Not used. Included for consistency with the generic \code{confint()} function.}

\item{level}{Confidence level. Default is \code{0.95}.}

\item{method}{Method used to build the confidence interval.
Choices include:
* \code{perc} - percentile,
* \code{bperc} - basic percentile,
* \code{aboot} - asymptotic bootstrap,
* \code{tboot} - bootstrap-t,
* \code{tsymboot} - symmetric bootstrap-t,
*  \code{all} - all the previous methods.
Default is \code{perc}.}

\item{recenter}{Logical. If \code{TRUE} it centers the intervals around
the mean value of the bootstrap samples. Relevant only for
\code{tboot} or \code{tsymboot} methods. By default it equals \code{FALSE}
unless the attribute kind of object \code{boodd} is \code{block}.}

\item{...}{Optional additional arguments.#' @details
This function provides confidence intervals using several methods, see
Efron and Tibshirani (1993), Bertail and Dudek (2025) for description.
The \code{tboot}
and \code{tsymboot} methods require the function to which the bootstrap
method is applied to return an even number of values corresponding to
parameter estimates (first \eqn{k} columns for the parameter of size \eqn{k}) and their variances
(columns \eqn{(k+1)} to \eqn{2k}).}
}
\value{
If the \code{method} argument is not \code{all}, the function
\code{confint.boodd} returns a two-column matrix representing the lower and
upper bounds of the interval. Each row of the matrix corresponds to the
variable to which the interval applies. The default value of the
\code{method} argument is \code{perc}. If the \code{method} argument is \code{all},
the function \code{confint.boodd} returns a list with the confidence
intervals for all supported methods.
}
\description{
Calculates confidence intervals for an object of class \code{boodd} returned
by bootstrap functions such as \code{\link{boots}}, \code{\link{bootsemi}}, \code{\link{blockboot}},
\code{\link{regenboot}}, etc.
}
\examples{
B <- 299
x <- round(rnorm(15),3)
boo1 <- boots(x,mean,B)
confint(boo1)
confint(boo1,method="bperc")

# bootstrap of several statistics 
mv <- function(data) {c(mean(data),var(data)/length(data))} # compute both mean and variance
boo2 <- boots(x,mv,B)
# Compute both percentile and t-percentile confidence intervals when variance is bootstrapped
confint(boo2,method="all")
}
\references{
Bertail, P. and Dudek, A. (2025). \emph{Bootstrap for
Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek) - submitted.

Efron, B., Tibshirani, R. (1993). \emph{An Introduction to the
Bootstrap}, Chapman and Hall.
}
\seealso{
\code{\link{plot.boodd}},\code{\link{summary.boodd}}.
}
\keyword{"Bootstrap"}
\keyword{"Confidence}
\keyword{intervals"}
