% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/best.block.sub.size.R
\name{best.block.sub.size}
\alias{best.block.sub.size}
\title{Optimal Block Subsampling Size}
\usage{
best.block.sub.size(X, func, PLT = TRUE, qq = 0.75, ...)
}
\arguments{
\item{X}{A numeric vector or time series data.}

\item{func}{A function applied to the blocks.}

\item{PLT}{Logical. If \code{TRUE} (default), plots the Kolmogorov distances
versus subsampling sizes.}

\item{qq}{A numeric value in the interval \eqn{(0, 1)}. Determines the scaling
factor for subsampling sizes. Higher values result in more subsampling
distributions being computed. Default is \eqn{0.75}.}

\item{...}{Optional additional arguments passed to the \code{func} function.}
}
\value{
Returns the optimal block size for subsampling.
If \code{PLT = TRUE}, a plot of Kolmogorov distances between consecutive subsampling distributions
versus subsampling sizes is also displayed.
}
\description{
This function determines the optimal block size for subsampling
using a distance-based method. It applies the Circular Block method and
calculates Kolmogorov distances to select the most suitable subsampling size.
}
\details{
The procedure relies on the method proposed by Bickel and Sakov (2008)
for determining optimal subsampling sizes. It computes a range of subsampling
distributions for sizes proportional to powers of \code{qq}. The function
then evaluates the Kolmogorov distance between consecutive subsampling
distributions to identify the optimal block size.
The function uses the Circular Block Bootstrap for generating subsamples.
Ensure that \code{qq} is set such that \eqn{\lfloor-\log(length(X))/\log(qq)\rfloor \leq 3};
otherwise, the function will return an error.
}
\examples{
 set.seed(12345)
 n = 1000 # sample size
 # generating an AR(1) Gaussian process with variance 1
 ts = arima.sim(n=n,model=list(ar=c(0.4)))*sqrt(1-0.4^2)
 bopt1=best.block.sub.size(ts,mean)
}
\references{
Bertail, P. and Dudek, A. (2025). \emph{Bootstrap for
Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek) - submitted.

Bickel, P., and Sakov, A. (2008). On the choice of m in the m out of n bootstrap and
confidence bounds for extrema. \emph{Statistica Sinica}, \bold{18} 967–985.
}
\seealso{
{\code{\link{block.sub}},
\code{\link{rate.sub}},
\code{\link{rate.block.sub}}}.
}
\keyword{bootstrap}
