% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/11_bondPricingSemiAnnualCoupon.R
\name{pricingSaCpnBond}
\alias{pricingSaCpnBond}
\title{Calculates Present Value or the Price of the Bond paying semi-annual Coupons.}
\usage{
pricingSaCpnBond(saCoupons, times, maturityVal, n, r)
}
\arguments{
\item{saCoupons}{A vector.}

\item{times}{A vector.}

\item{maturityVal}{A number.}

\item{n}{A number.}

\item{r}{A number.}
}
\value{
Input values to five arguments  \code{saCoupons} , \code{times}, \code{maturityVal},\code{n} and \code{r}.
}
\description{
Calculates Present Value or the Price of the Bond paying semi-annual Coupons.
}
\details{
The method  \code{pricingSaCpnBond()} is developed to compute the Price of Bond making semi-annual Coupon Payments. So,  \code{pricingSaCpnBond()} gives the Price of Bond making semi-annual Coupon Payments for values passed to its five arguments. Here, \code{saCoupons} represents the dollar values of all the semi-annual coupon payments till maturity, \code{times} is a vector of number of years ranging from 1 to any specified number of semi-annual periods till maturity, that is from 1 to times (n * 2), \code{maturityVal} is Maturity Value, \code{n} is number of years till maturity, and \code{r} is annual Market Discount Rate or Required Rate of return. The output is rounded off to two decimal places. The given examples show various ways in which the arguments can be passed to \code{pricingSaCpnBond()}.
}
\examples{
pricingSaCpnBond(saCoupons=c(4,4,4,4,4,4), times=c(1,2,3,4,5,6) ,maturityVal=100,n=3,r=0.07)
pricingSaCpnBond(saCoupons=c(4,4,4,4,4,4), times=c(1:6) ,maturityVal=100,n=6,r=0.06)
pricingSaCpnBond(saCoupons=c(rep(4,6)), times=c(1:6) ,maturityVal=100,n=6,r=0.06)
pricingSaCpnBond(c(rep(4,6)), c(1:6) ,100,6,0.06)
}
\references{
Adams,J.F. & Smith,D.J.(2019). Introduction to fixed-income valuation. In CFA Program Curriculum 2020 Level I Volumes 1-6. (Vol. 5, pp. 107-151). Wiley Professional Development (P&T). ISBN 9781119593577, \url{https://bookshelf.vitalsource.com/books/9781119593577}
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
