% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d03_computingMacDurationUsingBondFullPrice.R
\name{macDurationOnFP}
\alias{macDurationOnFP}
\title{Calculates Macaulay Duration using the Full Price of the Bond and Yield-To-Maturity.}
\usage{
macDurationOnFP(fp, n, ytm, cpn, mv, daysCpnToSettle, daysCouponPeriod)
}
\arguments{
\item{fp}{A number.}

\item{n}{A number.}

\item{ytm}{A number.}

\item{cpn}{A number.}

\item{mv}{A number.}

\item{daysCpnToSettle}{A number.}

\item{daysCouponPeriod}{A number}
}
\value{
Input values to seven arguments  \code{fp} , \code{n} , \code{ytm}, \code{cpn}, \code{mv}, \code{daysCpnToSettle} and \code{daysCouponPeriod}.
}
\description{
Calculates Macaulay Duration using the Full Price of the Bond and Yield-To-Maturity.
}
\details{
According to information provided by Adams and Smith (2019), the method \code{macDurationOnFP()} is developed to calculate Macaulay Duration using the Full Price of the Bond and Yield-To-Maturity.
Here, \code{fp} is Full Price of the bond, \code{n} is number of periods, \code{ytm} is yield-to-maturity, \code{coupon} is dollar value of the coupon payment, \code{maturityVal} is maturity Value, \code{daysCpnToSettle} is the number of days from the last coupon payment to the settlement date, and \code{daysCouponPeriod} is the number of days in the coupon period.
}
\examples{
macDurationOnFP(fp=100.9404,n=8*2,ytm=0.06/2,cpn=3,mv=100,daysCpnToSettle=57,daysCouponPeriod=180)
macDurationOnFP(fp=85.5031,n=10, ytm=0.104, cpn=8, mv=100,daysCpnToSettle=0,daysCouponPeriod=0)
}
\references{
Adams,J.F. & Smith,D.J.(2019). Understanding Fixed‑Income Risk and Return. In CFA Program Curriculum 2020 Level I Volumes 1-6. (Vol. 5, pp. 237-299). Wiley Professional Development (P&T). ISBN 9781119593577, \url{https://bookshelf.vitalsource.com/books/9781119593577}
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
