% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_batch_query.R
\name{run_batch_query}
\alias{run_batch_query}
\title{Batch Query and Save Data from Neo4j}
\usage{
run_batch_query(
  uri,
  user,
  password,
  query,
  field_names,
  filename = NULL,
  batch_size = 1000
)
}
\arguments{
\item{uri}{A string specifying the URI for the Neo4j database connection.}

\item{user}{A string specifying the username for the Neo4j database.}

\item{password}{A string specifying the password for the Neo4j database.}

\item{query}{A string containing the Cypher query to execute. The query should not include \code{SKIP} or \code{LIMIT}, as these are appended for batching.}

\item{field_names}{A character vector specifying the column names to use for the resulting data.}

\item{filename}{A string specifying the name of the TSV file to save the results. If NULL, a temporary file will be used.}

\item{batch_size}{An integer specifying the number of records to fetch per batch. Default is 1000.}
}
\value{
No return value, called for side effects.
}
\description{
This function performs batch queries to a Neo4j database and appends the results to a TSV file.
}
\examples{
\dontrun{
run_batch_query(
  uri = "bolt://localhost:7687",
  user = "<Username for Neo4j>",
  password = "<Password for Neo4j>",
  query = "MATCH (n) RETURN n LIMIT 10",
  field_names = c("id", "name"),
  filename = NULL,  # Writes to a temp file by default
  batch_size = 1000
)
}
}
