% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import-functions.R
\name{boilerplate_import}
\alias{boilerplate_import}
\title{Import boilerplate Database(s)}
\usage{
boilerplate_import(
  category = NULL,
  data_path = NULL,
  quiet = FALSE,
  project = "default"
)
}
\arguments{
\item{category}{Character or character vector. Category of database to import.
Options include "measures", "methods", "results", "discussion", "appendix", "template".
If NULL (default), imports all available categories as a unified database.
Ignored if data_path points to a specific file.}

\item{data_path}{Character. Can be either:
\itemize{
\item A directory path containing database files (original behaviour)
\item A specific file path to import (e.g., "data/methods_db_20240115_143022.rds")
If NULL (default), uses tools::R_user_dir("boilerplate", "data").
}}

\item{quiet}{Logical. If TRUE, suppresses all CLI alerts. Default is FALSE.}

\item{project}{Character. Project name for organizing databases. Default is "default".
Projects are stored in separate subdirectories to allow multiple independent
boilerplate collections.}
}
\value{
List. The imported database(s). If a single category was requested,
returns that database. If multiple categories were requested, returns a
unified database with each category as a named element.
}
\description{
This function imports one or more boilerplate databases from disk. It automatically
detects the file format (RDS or JSON) based on file extension. The function can
import from a directory (original behaviour) or from a specific file path (new).
}
\examples{
# Create a temporary directory and initialise databases
temp_dir <- tempdir()
data_path <- file.path(temp_dir, "boilerplate_import_example", "data")

# Initialise some databases first
boilerplate_init(
  categories = c("methods", "measures"),
  data_path = data_path,
  create_dirs = TRUE,
  create_empty = FALSE,
  confirm = FALSE,
  quiet = TRUE
)

# Import all databases as unified (new default)
unified_db <- boilerplate_import(data_path = data_path, quiet = TRUE)
names(unified_db)

# Access specific category
methods_db <- unified_db$methods
names(methods_db)

# Import from a specific file (e.g., timestamped or backup)
# First, save with timestamp to create a timestamped file
boilerplate_save(
  methods_db,
  category = "methods",
  data_path = data_path,
  timestamp = TRUE,
  confirm = FALSE,
  quiet = TRUE
)

# List files to see what's available
list.files(data_path, pattern = "methods.*\\\\.rds")

# Import the timestamped file directly
timestamped_file <- list.files(
  data_path, 
  pattern = "methods.*_\\\\d{8}_\\\\d{6}\\\\.rds", 
  full.names = TRUE
)[1]
if (length(timestamped_file) > 0 && file.exists(timestamped_file)) {
  methods_timestamped <- boilerplate_import(
    data_path = timestamped_file, 
    quiet = TRUE
  )
}

# Clean up
unlink(file.path(temp_dir, "boilerplate_import_example"), recursive = TRUE)

}
