% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bibliography-support.R
\name{boilerplate_copy_bibliography}
\alias{boilerplate_copy_bibliography}
\title{Copy Bibliography to Project Directory}
\usage{
boilerplate_copy_bibliography(
  db,
  target_dir = ".",
  overwrite = TRUE,
  update_first = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{db}{Database object containing bibliography information}

\item{target_dir}{Directory to copy the bibliography file to. Default is current directory.}

\item{overwrite}{Logical. Whether to overwrite existing file}

\item{update_first}{Logical. Whether to update from remote before copying}

\item{quiet}{Logical. Suppress messages}
}
\value{
Path to the copied bibliography file, or NULL if operation failed
}
\description{
Copies the bibliography file from cache to a specified directory,
typically for use with Quarto documents.
}
\examples{
\donttest{
# Create temporary directory for example
temp_dir <- tempfile()
dir.create(temp_dir)

# Initialise and import
boilerplate_init(data_path = temp_dir, create_dirs = TRUE, confirm = FALSE, quiet = TRUE)
db <- boilerplate_import(data_path = temp_dir, quiet = TRUE)

# Copy bibliography
boilerplate_copy_bibliography(db, temp_dir)

# Clean up
unlink(temp_dir, recursive = TRUE)
}

}
