% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reference_values.R
\name{percent_predicted}
\alias{percent_predicted}
\title{Get \% of expected value}
\usage{
percent_predicted(
  metric,
  sex,
  level,
  age,
  measurement,
  verbose = FALSE,
  digits = 0
)
}
\arguments{
\item{metric}{character (vector), body composition metric}

\item{sex}{character (vector), ""Female" or "Male"}

\item{level}{character (vector), used vertebral level}

\item{age}{integer (vector), age}

\item{measurement}{numeric (vector), raw value of measurement}

\item{verbose}{logical, should messages be displayed}

\item{digits}{integer, digits to round return value to}
}
\value{
numeric, corresponding percentile
}
\description{
For a given constellation of metric, sex, vertebral level, and age returns the ratio of actual and expected value (percentile 50) in percent
}
\examples{
\dontshow{if (requireNamespace("adiposerefdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
percent_predicted(metric=c("CSFA", "CSFA"), sex=c("Female","Male"),
                  level=c("T5","L3"), age=c(42,68), measurement=c(100,200))

\dontshow{\}) # examplesIf}
}
\seealso{
[bodycomp_reference()]
}
\author{
J. Peter Marquardt
}
