% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.variables.to.be.ordered.R
\name{check.variables.to.be.ordered}
\alias{check.variables.to.be.ordered}
\title{Check if the variables need to be ordered}
\usage{
check.variables.to.be.ordered(data.to.work)
}
\arguments{
\item{data.to.work}{is a data set with variables to check.}
}
\value{
TRUE or FALSE if need or not to tranform the variable into ordered factor.
}
\description{
This function receives a data set and check the level of each factor variable, if they have more than 2 levels the function recommend to check the need to transform it to ordered factor.
}
\examples{
# Clean environment
closeAllConnections()
rm(list=ls())
# Set enviroment
# setwd("to your working directory")
# Load packages
library(bnpa)
# Use working data sets from package
data(dataQualiN)
# Show first lines of data set
head(dataQualiN)
# Insert categorical variables with more than 2 levels
dataQualiN$test.variable[dataQualiN$A == "yes"] <- "low"
dataQualiN$test.variable[dataQualiN$B == "yes"] <- "medium"
dataQualiN$test.variable[dataQualiN$X == "yes"] <- "high"
# Transform it to factor variable
dataQualiN$test.variable <- as.factor(dataQualiN$test.variable)
# Check the necessity to transform in ordered variables
bnpa::check.variables.to.be.ordered(dataQualiN)
}
\references{
HAYES, A F; PREACHER, K J. Statistical mediation analysis with a multicategorical independent variable. British Journal of Mathematical and Statistical Psychology, v. 67, n. 3, p. 451-470, 2014.
}
\author{
Elias Carvalho
}
