% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.summary.R
\name{sucra}
\alias{sucra}
\title{Calculate SUCRA}
\usage{
sucra(result, txnames = NULL, catnames = NULL)
}
\arguments{
\item{result}{Object created by \code{\link{network.run}} function}

\item{txnames}{Treatment names used in creating legend}

\item{catnames}{Category names. Only used in multinomial.}
}
\value{
Returns SUCRA for each treatment
}
\description{
SUCRA is the surface under the cumulative ranking distribution defined in Salanti et al. (2011)
}
\examples{
########### certolizumab (with baseline risk)
network <- with(certolizumab, {
 network.data(Outcomes, Study, Treat, N=N, response = "binomial", Treat.order,
 baseline = "common", hy.prior = list("dhnorm", 0, 9.77))
})
\donttest{
result <- network.run(network)
sucra(result)
}
}
\references{
G. Salanti, A.E. Ades, J.P.A. Ioannidisa (2011), \emph{Graphical methods and numerical summaries for presenting results from multiple-treatment meta-analysis: an overview and tutorial}, Journal of Clinical Epidemiology 64(2):163-71. \doi{10.1016/j.jclinepi.2010.03.016}
}
\seealso{
\code{\link{rank.tx}}
}
