% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blr-model-fit-stats.R
\name{blr_rsq_nagelkerke}
\alias{blr_rsq_nagelkerke}
\title{Cragg-Uhler (Nagelkerke) R2}
\usage{
blr_rsq_nagelkerke(model)
}
\arguments{
\item{model}{An object of class \code{glm}.}
}
\value{
Cragg-Uhler (Nagelkerke) R2 pseudo r-squared.
}
\description{
Cragg-Uhler (Nagelkerke) R2 pseudo r-squared.
}
\examples{
model <- glm(honcomp ~ female + read + science, data = hsb2,
            family = binomial(link = 'logit'))

blr_rsq_nagelkerke(model)

}
\references{
Cragg, S. G., & Uhler, R. (1970). The demand for automobiles. Canadian Journal of Economics, 3, 386-406.

Maddala, G. S. (1983). Limited dependent and qualitative variables in economics. New York: Cambridge Press.

Nagelkerke, N. (1991). A note on a general definition of the coefficient of determination.
}
\seealso{
Other model fit statistics: 
\code{\link{blr_model_fit_stats}()},
\code{\link{blr_multi_model_fit_stats}()},
\code{\link{blr_pairs}()},
\code{\link{blr_rsq_adj_count}()},
\code{\link{blr_rsq_cox_snell}()},
\code{\link{blr_rsq_effron}()},
\code{\link{blr_rsq_mcfadden_adj}()},
\code{\link{blr_rsq_mckelvey_zavoina}()},
\code{\link{blr_test_lr}()}
}
\concept{model fit statistics}
