% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plugin-serialize.R
\name{preserve_board}
\alias{preserve_board}
\alias{preserve_board_server}
\alias{preserve_board_ui}
\title{Serialization plugin module}
\usage{
preserve_board(server = preserve_board_server, ui = preserve_board_ui)

preserve_board_server(id, board, ...)

preserve_board_ui(id, board)
}
\arguments{
\item{server, ui}{Server/UI for the plugin module}

\item{id}{Namespace ID}

\item{board}{The initial \code{board} object}

\item{...}{Extra arguments passed from parent scope}
}
\value{
A plugin container inheriting from \code{preserve_board} is returned by
\code{preserve_board()}, while the UI component (e.g. \code{preserve_board_ui()}) is
expected to return shiny UI (i.e. \code{\link[shiny:reexports]{shiny::tagList()}}) and the server
component (i.e. \code{preserve_board_server()}) is expected to return a
\code{\link[shiny:reactiveVal]{shiny::reactiveVal()}} or \code{\link[shiny:reactive]{shiny::reactive()}} which evaluates to \code{NULL} or a
\code{board} object.
}
\description{
Board state can be preserved by serializing all contained objects and
restored via de-serialization. This mechanism can be used to power features
such as save/restore (via download, as implemented in the default
\code{preserve_board} plugin), but more refined user experience is conceivable
in terms of undo/redo functionality and (automatic) saving of board state.
Such enhancements can be implemented in a third-party \code{preserve_board}
module.
}
