% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/block-class.R
\name{block_name}
\alias{block_name}
\alias{block_name<-}
\alias{validate_data_inputs}
\alias{block_inputs}
\alias{block_arity}
\title{Block utilities}
\usage{
block_name(x)

block_name(x) <- value

validate_data_inputs(x, data)

block_inputs(x)

block_arity(x)
}
\arguments{
\item{x}{An object inheriting from \code{"block"}}

\item{value}{New value}

\item{data}{Data input values}
}
\value{
Return types vary among the set of exported utilities:
\itemize{
\item \code{block_name()}: string valued block name,
\item \verb{block_name<-()}: \code{x} (invisibly),
\item \code{validate_data_inputs()}: \code{NULL} if no validator is set and the result of
the validator function otherwise,
\item \code{block_inputs()}: a (possibly empty) character vector of data input names,
\item \code{block_arity()}: a scalar integer with \code{NA} in case of variadic behavior.
}
}
\description{
Several utilities for working (and manipulating) \code{block} objects are exported
and developers are encouraged to use these instead of relying on object
implementation to extract or modify attributes. If functionality for working
with blocks in lacking, please consider opening an
\href{https://github.com/BristolMyersSquibb/blockr.core/issues/new}{issue}.
}
\section{Block name}{

Each block can have a name (by default constructed from the class vector)
intended for users to easily identify different blocks. This name can freely
be changed during the lifetime of a block and no uniqueness restrictions are
in place. The current block name can be retrieved with \code{block_name()} and
set as \code{block_name(x) <- "some name"}.
}

\section{Input validation}{

Data input validation is available via \code{validate_data_inputs()} which uses
the (optional) validator function passed to \code{\link[=new_block]{new_block()}} at construction
time. This mechanism can be used to prevent premature evaluation of the
block expression as this might lead to unexpected errors.
}

\section{Block arity/inputs}{

The set of explicit (named) data inputs for a block is available as
\code{block_inputs()}, while the block arity can be queried with \code{block_arity()}.
In case of variadic blocks (i.e. blocks that take a variable number of
inputs like for example a block providing \code{\link[base:cbind]{base::rbind()}}-like
functionality), \code{block_arity()} returns \code{NA} and the special block server
function argument \code{...args}, signalling variadic behavior is stripped from
\code{block_inputs()}.
}

\examples{
blk <- new_dataset_block()
block_name(blk)
block_name(blk) <- "My dataset block"
block_name(blk)

block_inputs(new_dataset_block())
block_arity(new_dataset_block())

block_inputs(new_merge_block())
block_arity(new_merge_block())

block_inputs(new_rbind_block())
block_arity(new_rbind_block())

}
