% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmd-exec.R
\name{exec}
\alias{exec}
\title{Invoke a System Command}
\usage{
exec(cmd, ...)
}
\arguments{
\item{cmd}{Command to be invoked, as a character string.}

\item{...}{<\link[rlang:dyn-dots]{dynamic dots}> Additional arguments passed to \code{cmd} command. Empty arguments are automatically trimmed. If a single argument, such as a file path, contains spaces, it must be quoted, for example using \code{\link[=shQuote]{shQuote()}}.}
}
\value{
A \code{command} object.
}
\description{
Invoke a System Command
}
\section{\code{command} collections}{

\itemize{
\item \code{\link[=allele_counter]{allele_counter()}}
\item \code{\link[=cellranger]{cellranger()}}
\item \code{\link[=conda]{conda()}}
\item \code{\link[=fastq_pair]{fastq_pair()}}
\item \code{\link[=gistic2]{gistic2()}}
\item \code{\link[=kraken_tools]{kraken_tools()}}
\item \code{\link[=kraken2]{kraken2()}}
\item \code{\link[=perl]{perl()}}
\item \code{\link[=pyscenic]{pyscenic()}}
\item \code{\link[=python]{python()}}
\item \code{\link[=samtools]{samtools()}}
\item \code{\link[=seqkit]{seqkit()}}
\item \code{\link[=trust4]{trust4()}}
}
}

\examples{
cmd_run(exec("echo", "$PATH"))
}
\seealso{
\itemize{
\item \code{\link[=cmd_wd]{cmd_wd()}}/\code{\link[=cmd_envvar]{cmd_envvar()}}/\code{\link[=cmd_envpath]{cmd_envpath()}}/\code{\link[=cmd_conda]{cmd_conda()}}
\item \code{\link[=cmd_on_start]{cmd_on_start()}}/\code{\link[=cmd_on_exit]{cmd_on_exit()}}
\item \code{\link[=cmd_on_succeed]{cmd_on_succeed()}}/\code{\link[=cmd_on_fail]{cmd_on_fail()}}
\item \code{\link[=cmd_parallel]{cmd_parallel()}}
}
}
