% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmd-.R
\name{Command}
\alias{Command}
\title{R6 Class to prepare command parameters.}
\description{
\code{Command} is an R6 class used by developers to create new command. It should
not be used by end users.
}
\seealso{
make_command
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Command-new}{\code{Command$new()}}
\item \href{#method-Command-build_command}{\code{Command$build_command()}}
\item \href{#method-Command-get_on_start}{\code{Command$get_on_start()}}
\item \href{#method-Command-get_on_exit}{\code{Command$get_on_exit()}}
\item \href{#method-Command-get_on_fail}{\code{Command$get_on_fail()}}
\item \href{#method-Command-get_on_succeed}{\code{Command$get_on_succeed()}}
\item \href{#method-Command-print}{\code{Command$print()}}
\item \href{#method-Command-clone}{\code{Command$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Command-new"></a>}}
\if{latex}{\out{\hypertarget{method-Command-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{Command} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Command$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Additional argument passed into command.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Command-build_command"></a>}}
\if{latex}{\out{\hypertarget{method-Command-build_command}{}}}
\subsection{Method \code{build_command()}}{
Build the command line
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Command$build_command(help = FALSE, verbose = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{help}}{A boolean value indicating whether to build parameters
for help document or not.}

\item{\code{verbose}}{A boolean value indicating whether the command
execution should be verbose.}

\item{\code{envir}}{An environment used to Execute command.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An atomic character combine the command and parameters.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Command-get_on_start"></a>}}
\if{latex}{\out{\hypertarget{method-Command-get_on_start}{}}}
\subsection{Method \code{get_on_start()}}{
Get the command startup code
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Command$get_on_start()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of \code{\link[rlang:defusing-advanced]{quosures}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Command-get_on_exit"></a>}}
\if{latex}{\out{\hypertarget{method-Command-get_on_exit}{}}}
\subsection{Method \code{get_on_exit()}}{
Get the command exit code
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Command$get_on_exit()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of \code{\link[rlang:defusing-advanced]{quosures}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Command-get_on_fail"></a>}}
\if{latex}{\out{\hypertarget{method-Command-get_on_fail}{}}}
\subsection{Method \code{get_on_fail()}}{
Get the command failure code
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Command$get_on_fail()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of \code{\link[rlang:defusing-advanced]{quosures}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Command-get_on_succeed"></a>}}
\if{latex}{\out{\hypertarget{method-Command-get_on_succeed}{}}}
\subsection{Method \code{get_on_succeed()}}{
Get the command succeessful code
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Command$get_on_succeed()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of \code{\link[rlang:defusing-advanced]{quosures}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Command-print"></a>}}
\if{latex}{\out{\hypertarget{method-Command-print}{}}}
\subsection{Method \code{print()}}{
Build parameters to run command.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Command$print(indent = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{indent}}{A single integer number giving the space of indent.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The object itself.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Command-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Command-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Command$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
