% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blandr.statistics.r
\name{blandr.statistics}
\alias{blandr.statistics}
\title{Bland-Altman statistics for R}
\usage{
blandr.statistics(method1, method2, sig.level = 0.95, LoA.mode = 1)
}
\arguments{
\item{method1}{Either a formula, or a vector of numbers corresponding to the results from method 1.}

\item{method2}{A vector of numbers corresponding to the results from method 2. Only needed if \code{X} is a vector.}

\item{sig.level}{(Optional) Two-tailed significance level. Expressed from 0 to 1. Defaults to 0.95.}

\item{LoA.mode}{(Optional) Switch to change how accurately the limits of agreement (LoA) are calculated from the bias and its standard deviation. The default is LoA.mode=1 which calculates LoA with the more accurate 1.96x multiplier. LoA.mode=2 uses the 2x multiplier which was used in the original papers. This should really be kept at default, except to double check calculations in older papers.}
}
\value{
An object of class 'blandr' is returned. This is a list with the following elements:
\item{means}{List of arithmetic mean of the two methods}
\item{differences}{List of differences of the two methods}
\item{method1}{Returns the 'method1' list in the data frame if further evaluation is needed}
\item{method2}{Returns the 'method2' list in the data frame if further evaluation is needed}
\item{sig.level}{Significance level supplied to the function}
\item{sig.level.convert.to.z}{Significance level convert to Z value}
\item{bias}{Bias of the two methods}
\item{biasUpperCI}{Upper confidence interval of the bias (based on significance level)}
\item{biasLowerCI}{Lower confidence interval of the bias (based on significance level)}
\item{biasStdDev}{Standard deviation for the bias}
\item{biasSEM}{Standard error for the bias}
\item{LOA_SEM}{Standard error for the limits of agreement}
\item{upperLOA}{Upper limit of agreement}
\item{upperLOA_upperCI}{Upper confidence interval of the upper limit of agreement}
\item{upperLOA_lowerCI}{Lower confidence interval of the upper limit of agreement}
\item{lowerLOA}{Lower limit of agreement}
\item{lowerLOA_upperCI}{Upper confidence interval of the lower limit of agreement}
\item{lowerLOA_lowerCI}{Lower confidence interval of the lower limit of agreement}
\item{proportion}{Differences/means*100}
\item{no.of.observations}{Number of observations}
\item{regression.equation}{A regression equation to help determine if there is any proportional bias}
\item{regression.fixed.slope}{The slope value of the regression equation}
\item{regression.fixed.intercept}{The intercept value of the regression equation}
}
\description{
Bland-Altman analysis function for R. Package created as existing
functions don't suit my needs, and don't generate 95\\% confidence intervals
for bias and limits of agreement. This base function calculates the basic
statistics, and generates return values which can be used in the related
\code{blandr.display} and \code{bland.altamn.plot} functions. However
the return results can be used to generate a custom chart if desired.
}
\note{
The function will give similar answers when used on the original Bland-Altman PEFR data sets. They won't be exactly the same as (a) for 95\\% limits of agreement I have used +/-1.96, rather than 2, and (b) the computerised calculation means that the rounding that is present in each step of the original examples does not occur. This will give a more accurate answer, although I can understand why in 1986 rounding would occur at each step for ease of calculation.

The function depends on paired values.

It currently only can currently work out fixed bias.

Improvements for the future: proportional bias charts will need further work

Started 2015-11-14

Last update 2016-02-04

Originally designed for LAVAS and CVLA
}
\examples{

# Generates two random measurements
measurement1 <- rnorm(100)
measurement2 <- rnorm(100)

# Generates Bland-Altman statistics data of the two measurements
blandr.statistics( measurement1 , measurement2 )

}
\references{
Based on: (1) Bland, J. M., & Altman, D. (1986). Statistical methods for assessing agreement between two methods of clinical measurement. The Lancet, 327(8476), 307-310. http://dx.doi.org/10.1016/S0140-6736(86)90837-8

Confidence interval work based on follow-up paper: (2) Altman, D. G., & Bland, J. M. (2002). Commentary on quantifying agreement between two methods of measurement. Clinical chemistry, 48(5), 801-802. http://www.clinchem.org/content/48/5/801.full.pdf
}
\author{
Deepankar Datta \href{mailto:deepankar.datta@gmail.com}{deepankar.datta@gmail.com}
}
