% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_mapping.R
\name{get_model_data}
\alias{get_model_data}
\title{Mapping of Simulation Model Functions}
\usage{
get_model_data(simulation_model = NULL)
}
\arguments{
\item{simulation_model}{(optional) character with a valid model key or
\code{NULL}.}
}
\value{
If simulation_model is \code{NULL} or missing, a character vector of
possible names. Otherwise, a list including information of the relevant
function:
\itemize{
\item ode: Pointer to the function defining the model ode.
\item cost: Pointer to the function calculating the error of the
approximation.
\item dtemp: logical defining whether the function requires the
definition of the first derivative of temperature.
\item variables: a character vector defining which entry variables
are needed by the model.
\item variables_priv: for internal use only.
\item parameters: character vector with the parameters needed by
the model.
}
}
\description{
Provides information about the function for dynamic predictions associated
to a valid \code{simulation_model} key.
If \code{simulation_model} is missing or \code{NULL}, a character vector
of valid model keys is provided.
This function is designed as an assistant for using the functions
\code{\link{predict_inactivation}} and
\code{\link{fit_dynamic_inactivation}}.
For the adjustment of isothermal experiments with the function
\code{\link{fit_isothermal_inactivation}}, use the function
\code{\link{get_isothermal_model_data}}.
}
\seealso{
\code{\link{predict_inactivation}},
\code{\link{fit_dynamic_inactivation}}
}
